/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AttributeInfoCommand
extends BasicCommand {
    public AttributeInfoCommand(Heroes plugin) {
        super("Attribute Information");
        this.setDescription("Displays information regarding attributes");
        this.setUsage("/attribute info \u00a79<attribute>");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("attribute info", "hero attribute info");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length > 0) {
            AttributeType type = AttributeType.matchAttribute(args[0]);
            if (type == null) {
                player.sendMessage(ChatColor.RED + "That Attribute does not exist!");
                return false;
            }
            sender.sendMessage(ChatColor.RED + "-----[ " + ChatColor.WHITE + "Attribute Information" + ChatColor.RED + " ]-----");
            this.displayAttributeInfo(player, type);
        } else {
            sender.sendMessage(ChatColor.RED + "-----[ " + ChatColor.WHITE + "Attribute Information" + ChatColor.RED + " ]-----");
            this.displayAttributeInfo(player, AttributeType.STRENGTH);
            this.displayAttributeInfo(player, AttributeType.CONSTITUTION);
            this.displayAttributeInfo(player, AttributeType.ENDURANCE);
            this.displayAttributeInfo(player, AttributeType.DEXTERITY);
            this.displayAttributeInfo(player, AttributeType.INTELLECT);
            this.displayAttributeInfo(player, AttributeType.WISDOM);
            this.displayAttributeInfo(player, AttributeType.CHARISMA);
        }
        return true;
    }

    private void displayAttributeInfo(Player player, AttributeType type) {
        Object infoString = "";
        switch (type) {
            case STRENGTH: {
                infoString = ChatColor.GREEN + "  Strength: " + ChatColor.GRAY;
                infoString = (String)infoString + "The Strength attribute increases damage with melee weapons, as well as damage with physical based abilities.";
                player.sendMessage((String)infoString);
                break;
            }
            case CONSTITUTION: {
                infoString = ChatColor.GREEN + "  Constitution: " + ChatColor.GRAY;
                infoString = (String)infoString + "The Constitution attribute increases your maximum health pool, and also provides slight resistances to magic based damage.";
                player.sendMessage((String)infoString);
                break;
            }
            case ENDURANCE: {
                infoString = ChatColor.GREEN + "  Endurance: " + ChatColor.GRAY;
                infoString = (String)infoString + "The Endurance attribute increases your base stamina regeneration, and also increases your maximum equipment weight. A high equipment weight value will be required to wear several pieces of armor at once.";
                player.sendMessage((String)infoString);
                break;
            }
            case DEXTERITY: {
                infoString = ChatColor.GREEN + "  Dexterity: " + ChatColor.GRAY;
                infoString = (String)infoString + "The Dexterity attribute increases damage with projectile based weaponry, as well as your base movement speed. The effectiveness of certain abilities may also be increased by this attribute.";
                player.sendMessage((String)infoString);
                break;
            }
            case INTELLECT: {
                infoString = ChatColor.GREEN + "  Intellect: " + ChatColor.GRAY;
                infoString = (String)infoString + "The Intellect attribute increases your maximum mana pool, and also increases the damage dealt by magic based abilities.";
                player.sendMessage((String)infoString);
                break;
            }
            case WISDOM: {
                infoString = ChatColor.GREEN + "  Wisdom: " + ChatColor.GRAY;
                infoString = (String)infoString + "The Wisdom attribute increases your base mana regeneration, and also increases the effectiveness of healing based abilities.";
                player.sendMessage((String)infoString);
                break;
            }
            case CHARISMA: {
                infoString = ChatColor.GREEN + "  Charisma: " + ChatColor.GRAY;
                infoString = (String)infoString + "The Charisma attribute increases the potency of songs, and increases the duration and effectiveness of certain disabling abilities.";
                player.sendMessage((String)infoString);
                break;
            }
            default: {
                return;
            }
        }
    }
}

