/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicInteractiveCommand;
import com.herocraftonline.heroes.command.BasicInteractiveCommandState;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AttributeAddCommand
extends BasicInteractiveCommand {
    private final Heroes plugin;
    private final Map<String, String> pendingAttributeClass = new HashMap<String, String>();
    private final Map<String, AttributeType> pendingAttributeSelections = new HashMap<String, AttributeType>();
    private final Map<String, Integer> pendingAttributeIncreaseValue = new HashMap<String, Integer>();
    private final Map<String, Integer> pendingAttributeAllocationCost = new HashMap<String, Integer>();

    public AttributeAddCommand(Heroes plugin) {
        super("Attribute Add");
        this.plugin = plugin;
        this.setStates(new StateA(), new StateB());
        this.setDescription("Allocate Attribute Points towards a specific attribute.");
        this.setUsage("/attribute add \u00a79<attribute> <amount>");
        this.setArgumentRange(1, 2);
    }

    @Override
    public String getCancelIdentifier() {
        return "attribute add cancel";
    }

    @Override
    public void onCommandCancelled(CommandSender executor) {
        if (!(executor instanceof Player)) {
            return;
        }
        this.pendingAttributeSelections.remove(executor.getName());
        this.pendingAttributeIncreaseValue.remove(executor.getName());
        this.pendingAttributeAllocationCost.remove(executor.getName());
    }

    class StateA
    extends BasicInteractiveCommandState {
        public StateA() {
            super("attribute add");
            this.setArgumentRange(1, 2);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return false;
            }
            Player player = (Player)executor;
            Hero hero = AttributeAddCommand.this.plugin.getCharacterManager().getHero(player);
            int allocationPoints = hero.getAllocationPoints();
            AttributeType type = AttributeType.matchAttribute(args[0]);
            if (type == null) {
                player.sendMessage(ChatColor.RED + "That Attribute does not exist!");
                return false;
            }
            int increaseAmount = 1;
            if (args.length > 1) {
                try {
                    increaseAmount = Integer.parseInt(args[1]);
                    if (increaseAmount < 1) {
                        player.sendMessage(ChatColor.RED + "You must choose to add a number greater than 0.");
                        return false;
                    }
                }
                catch (Exception e) {
                    player.sendMessage(ChatColor.RED + "That is not a valid amount to increase that attribute by!");
                    return false;
                }
            }
            if (allocationPoints < 1) {
                player.sendMessage(ChatColor.RED + "You don't have any allocation points!");
                return false;
            }
            int allocationCost = hero.getAttributeAllocationCost(hero.getHeroClass(), type, increaseAmount);
            if (allocationPoints < allocationCost) {
                player.sendMessage(ChatColor.RED + "You don't have enough allocation points for that. " + ChatColor.GRAY + "It would cost " + ChatColor.WHITE + allocationCost + ChatColor.GRAY + " of your allocation points to increase your " + ChatColor.WHITE + WordUtils.capitalizeFully((String)type.toString()) + ChatColor.GRAY + " attribute by " + ChatColor.WHITE + increaseAmount + ChatColor.GRAY + ".");
                return false;
            }
            if (allocationCost < 0) {
                return false;
            }
            player.sendMessage(ChatColor.GRAY + "You are about to spend " + ChatColor.WHITE + allocationCost + ChatColor.GRAY + " of your allocation points to increase your " + ChatColor.WHITE + WordUtils.capitalizeFully((String)type.toString()) + ChatColor.GRAY + " attribute by " + ChatColor.WHITE + increaseAmount + ChatColor.GRAY + ".");
            ChatComponents.ConfirmOrCancel.ATTRIBUTE_ADD.send(executor);
            AttributeAddCommand.this.pendingAttributeClass.put(player.getName(), hero.getHeroClass().getName());
            AttributeAddCommand.this.pendingAttributeSelections.put(player.getName(), type);
            AttributeAddCommand.this.pendingAttributeIncreaseValue.put(player.getName(), increaseAmount);
            AttributeAddCommand.this.pendingAttributeAllocationCost.put(player.getName(), allocationCost);
            return true;
        }
    }

    class StateB
    extends BasicInteractiveCommandState {
        public StateB() {
            super("attribute add confirm");
            this.setArgumentRange(0, 0);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return true;
            }
            Player player = (Player)executor;
            final Hero hero = AttributeAddCommand.this.plugin.getCharacterManager().getHero(player);
            final HeroClass heroClass = AttributeAddCommand.this.plugin.getClassManager().getClass(AttributeAddCommand.this.pendingAttributeClass.remove(player.getName()));
            AttributeType type = AttributeAddCommand.this.pendingAttributeSelections.remove(player.getName());
            int allocationPointsModifierValue = AttributeAddCommand.this.pendingAttributeAllocationCost.remove(player.getName());
            int attributeModifierValue = AttributeAddCommand.this.pendingAttributeIncreaseValue.remove(player.getName());
            if (hero.modifyAttribute(heroClass, type, attributeModifierValue, allocationPointsModifierValue * -1)) {
                String successString = "You have successfully spent " + ChatColor.WHITE + allocationPointsModifierValue + ChatColor.GRAY + " of your allocation points to increase your " + ChatColor.WHITE + WordUtils.capitalizeFully((String)type.toString()) + ChatColor.GRAY + " attribute by " + ChatColor.WHITE + attributeModifierValue + ChatColor.GRAY + "!";
                player.sendMessage(ChatColor.GRAY + successString);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)AttributeAddCommand.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        hero.recalculateAttributesAndAllocationPoints(heroClass, hero.getHeroLevel(heroClass));
                    }
                }, 2L);
                return true;
            }
            AttributeAddCommand.this.cancelInteraction((CommandSender)player);
            player.sendMessage(ChatColor.RED + "There was an error when attempting to increase your attribute value.");
            return true;
        }
    }
}

