/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ArmorWeightCommand
extends BasicCommand {
    private final Heroes plugin;

    public ArmorWeightCommand(Heroes plugin) {
        super("Armor");
        this.plugin = plugin;
        this.setDescription("Displays equipment weight information for all armors.");
        this.setUsage("/hero armor");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("hero armor");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Map<Material, Double> armors = Heroes.properties.equipmentWeightMap;
        if (armors.isEmpty()) {
            sender.sendMessage("This server does not have any equipment weight values set!");
            return false;
        }
        String[] categories = new String[]{"Helmet", "Chestplate", "Leggings", "Boots"};
        String[] categorizedArmors = new String[categories.length];
        String helmets = "Leather: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.LEATHER_HELMET)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Gold: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.GOLDEN_HELMET)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Chainmail: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.CHAINMAIL_HELMET)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Iron: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.IRON_HELMET)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Diamond: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.DIAMOND_HELMET)) + ChatColor.WHITE;
        String chestplates = "Leather: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.LEATHER_CHESTPLATE)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Gold: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.GOLDEN_CHESTPLATE)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Chainmail: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.CHAINMAIL_CHESTPLATE)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Iron: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.IRON_CHESTPLATE)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Diamond: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.DIAMOND_CHESTPLATE)) + ChatColor.WHITE;
        String leggings = "Leather: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.LEATHER_LEGGINGS)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Gold: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.GOLDEN_LEGGINGS)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Chainmail: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.CHAINMAIL_LEGGINGS)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Iron: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.IRON_LEGGINGS)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Diamond: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.DIAMOND_LEGGINGS)) + ChatColor.WHITE;
        String boots = "Leather: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.LEATHER_BOOTS)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Gold: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.GOLDEN_BOOTS)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Chainmail: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.CHAINMAIL_BOOTS)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Iron: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.IRON_BOOTS)) + ChatColor.WHITE + ", " + ChatColor.WHITE + "Diamond: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.DIAMOND_BOOTS)) + ChatColor.WHITE;
        if (Properties.SUBVERSION > 15) {
            helmets = helmets + ", Netherite: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.getMaterial((String)"NETHERITE_HELMET"))) + ChatColor.WHITE;
            chestplates = chestplates + ", Netherite: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.getMaterial((String)"NETHERITE_CHESTPLATE"))) + ChatColor.WHITE;
            leggings = leggings + ", Netherite: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.getMaterial((String)"NETHERITE_LEGGINGS"))) + ChatColor.WHITE;
            boots = boots + ", Netherite: " + ChatColor.GRAY + ArmorWeightCommand.decFormatWeight(armors.get(Material.getMaterial((String)"NETHERITE_BOOTS"))) + ChatColor.WHITE;
        }
        categorizedArmors[0] = helmets;
        categorizedArmors[1] = chestplates;
        categorizedArmors[2] = leggings;
        categorizedArmors[3] = boots;
        Hero hero = this.plugin.getCharacterManager().getHero((Player)sender);
        double currentEquipmentWeight = hero.getCurrentEquipmentWeight();
        double maxEquipmentWeight = hero.resolveMaxEquipmentWeight();
        sender.sendMessage("\u00a7c--------[ \u00a7fArmor Equipment Weight Information\u00a7c ]--------");
        sender.sendMessage("\u00a7c--------[ " + ChatColor.GOLD + "Current Equipment Weight: " + ChatColor.WHITE + Util.decFormat.format(currentEquipmentWeight) + ChatColor.WHITE + "/" + Util.decFormat.format(maxEquipmentWeight) + "\u00a7c ]--------");
        for (int i = 0; i < categories.length; ++i) {
            sender.sendMessage("  \u00a7a" + categories[i] + ": \u00a7f" + categorizedArmors[i]);
        }
        return true;
    }

    private static String decFormatWeight(Double weight) {
        return weight == null ? "null" : Util.decFormat.format(weight);
    }
}

