/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.MaterialUtil;
import java.util.EnumSet;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ArmorAllowedCommand
extends BasicCommand {
    private final Heroes plugin;

    public ArmorAllowedCommand(Heroes plugin) {
        super("Armor");
        this.plugin = plugin;
        this.setDescription("Displays armor available for your class");
        this.setUsage("/hero armor \u00a79[class]");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("hero armor");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        int i;
        if (!(sender instanceof Player) && args.length < 1) {
            sender.sendMessage("You must specify a class.");
            return false;
        }
        EnumSet<Material> allArmors = EnumSet.noneOf(Material.class);
        boolean givenHero = false;
        Hero hero = null;
        HeroClass heroClass = null;
        if (args.length == 0) {
            Player player = (Player)sender;
            hero = this.plugin.getCharacterManager().getHero(player);
            allArmors.addAll(hero.getHeroClass().getAllowedArmor());
            if (hero.getSecondaryClass() != null) {
                allArmors.addAll(hero.getSecondaryClass().getAllowedArmor());
            }
            if (hero.getRaceClass() != null) {
                allArmors.addAll(hero.getRaceClass().getAllowedArmor());
            }
            givenHero = true;
        } else {
            heroClass = this.plugin.getClassManager().getClass(args[0]);
            if (heroClass == null) {
                sender.sendMessage(ChatColor.RED + args[0] + " is not a valid class");
                return false;
            }
            allArmors.addAll(heroClass.getAllowedArmor());
        }
        if (allArmors.isEmpty()) {
            sender.sendMessage("Those classes do not allow you to wear any armors");
            return false;
        }
        String[] categories = new String[]{"Helmet", "Chestplate", "Leggings", "Boots"};
        String[] categorizedArmors = new String[categories.length];
        for (int i2 = 0; i2 < categories.length; ++i2) {
            categorizedArmors[i2] = "";
        }
        HeroClass primClass = null;
        HeroClass profClass = null;
        HeroClass raceClass = null;
        if (givenHero) {
            primClass = hero.getHeroClass();
            profClass = hero.getSecondaryClass();
            raceClass = hero.getRaceClass();
        }
        block1: for (Material mat : allArmors) {
            String armor = mat.name();
            for (int i3 = 0; i3 < categories.length; ++i3) {
                int maxRequiredLevel;
                if (!armor.endsWith(categories[i3].toUpperCase())) continue;
                boolean levelMet = true;
                if (givenHero) {
                    if (!(hero.isAllowedArmor(primClass, mat) || hero.isAllowedArmor(profClass, mat) || hero.isAllowedArmor(raceClass, mat))) {
                        maxRequiredLevel = hero.getMaxRequiredAllowedArmorLevel(mat);
                        levelMet = false;
                    } else {
                        maxRequiredLevel = hero.getMaxAllowedArmorLevel(mat);
                    }
                } else {
                    maxRequiredLevel = heroClass.getAllowedArmorLevel(mat);
                }
                Object materialString = MaterialUtil.getFriendlyName(armor).split(" ")[0];
                if (maxRequiredLevel > 1) {
                    materialString = (String)materialString + " (Lvl " + maxRequiredLevel + ")";
                }
                if (!levelMet) {
                    int n = i3;
                    categorizedArmors[n] = categorizedArmors[n] + ChatColor.RED + (String)materialString + ChatColor.RESET + ", ";
                    continue block1;
                }
                int n = i3;
                categorizedArmors[n] = categorizedArmors[n] + (String)materialString + ", ";
                continue block1;
            }
        }
        for (i = 0; i < categories.length; ++i) {
            if (categorizedArmors[i].isEmpty()) continue;
            categorizedArmors[i] = categorizedArmors[i].substring(0, categorizedArmors[i].length() - 2);
        }
        sender.sendMessage("\u00a7c--------[ \u00a7fAllowed Armor\u00a7c ]--------");
        for (i = 0; i < categories.length; ++i) {
            sender.sendMessage("  \u00a7a" + categories[i] + ": \u00a7f" + categorizedArmors[i]);
        }
        return true;
    }
}

