/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.ultimate.UltimateClassDependencyUtil;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Properties;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminUltimateRequiredClassesCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminUltimateRequiredClassesCommand(Heroes plugin) {
        super("Admin Ultimate Class Required Classes");
        this.plugin = plugin;
        this.setDescription("View Classes Required for an Ultimate Class For The Given Player");
        this.setUsage("/hero admin formula <player> <class> [#]");
        this.setArgumentRange(2, 3);
        this.setIdentifiers("hero admin formula");
        this.setPermission("heroes.admin.formula");
    }

    @Override
    public boolean execute(CommandSender executor, String identifier, String[] args) {
        Player p = Bukkit.getPlayer((String)args[0]);
        if (p == null) {
            executor.sendMessage("Could not find player " + args[0]);
            return false;
        }
        HeroClass hc = this.plugin.getClassManager().getClass(args[1]);
        if (hc == null) {
            executor.sendMessage("Could not find class " + args[1]);
            return false;
        }
        if (!hc.isUltimate()) {
            executor.sendMessage("Not an ultimate class!");
            return false;
        }
        HeroClass.UltimateInfo info = hc.getUltimateInfo();
        Set<Integer> reqs = UltimateClassDependencyUtil.getRequiredHeroClassIds(p.getUniqueId(), info.getCount(), info.getMin(), info.getMax());
        int i = -1;
        if (args.length > 2) {
            try {
                i = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (i < 1 || i > reqs.size()) {
                executor.sendMessage("Invalid index value!");
                return false;
            }
        }
        int c = 1;
        for (Integer val : reqs) {
            if (i > 0 && i == c) {
                executor.sendMessage("To continue your path to soul enlightenment, you must master the " + Properties.classIdMap[val] + ".");
            } else if (i < 0) {
                executor.sendMessage("To continue your path to soul enlightenment, you must master the " + Properties.classIdMap[val] + ".");
            }
            ++c;
        }
        return true;
    }
}

