/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.ultimate.UltimateClassDependencyUtil;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Properties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminUltimateCheckClassesCommand
extends BasicCommand {
    private static final List<String> PROGRESS_MESSAGE = new ArrayList<String>();
    private final Heroes plugin;

    public AdminUltimateCheckClassesCommand(Heroes plugin) {
        super("Admin Ultimate Class Check Classes");
        this.plugin = plugin;
        this.setDescription("Check the progress of a player for a given ultimate class.");
        this.setUsage("/hero admin ultimatecheck <player> <class>");
        this.setArgumentRange(2, 2);
        this.setIdentifiers("hero admin ultimatecheck");
        this.setPermission("heroes.admin.ultimatecheck");
    }

    @Override
    public boolean execute(CommandSender executor, String identifier, String[] args) {
        Player p = Bukkit.getPlayer((String)args[0]);
        if (p == null) {
            executor.sendMessage("Could not find player " + args[0]);
            return false;
        }
        Hero h = this.plugin.getCharacterManager().getHero(p);
        HeroClass hc = this.plugin.getClassManager().getClass(args[1]);
        if (hc == null) {
            executor.sendMessage("Could not find class " + args[1]);
            return false;
        }
        if (!hc.isUltimate()) {
            executor.sendMessage("Not an ultimate class!");
            return false;
        }
        HeroClass.UltimateInfo info = hc.getUltimateInfo();
        Set<Integer> reqs = UltimateClassDependencyUtil.getRequiredHeroClassIds(p.getUniqueId(), info.getCount(), info.getMin(), info.getMax());
        int c = 0;
        for (int classId : reqs) {
            if (!h.hasMastered(this.plugin.getClassManager().getClass(Properties.classIdMap[classId]))) continue;
            ++c;
        }
        if (c >= PROGRESS_MESSAGE.size() || c <= -1) {
            executor.sendMessage("Invalid class count configuration. Please notify an admin.");
            return false;
        }
        executor.sendMessage(PROGRESS_MESSAGE.get(c));
        return true;
    }

    static {
        PROGRESS_MESSAGE.add("You feel no connection with your soul.");
        PROGRESS_MESSAGE.add("You feel a little connection with your soul.");
        PROGRESS_MESSAGE.add("You almost notice something different about yourself.");
        PROGRESS_MESSAGE.add("You feel a faint sense of enlightenment.");
        PROGRESS_MESSAGE.add("You feel the presence of something greater surge within you.");
        PROGRESS_MESSAGE.add("You have a strong sense of the soul within you.");
        PROGRESS_MESSAGE.add("You feel an inner glow. You are enlightened.");
    }
}

