/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeSet;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.command.commands.StatsInfoCommand;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminStatsInfoCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminStatsInfoCommand(Heroes plugin) {
        super("View a Player's Statistic Information");
        this.plugin = plugin;
        this.setDescription("Displays a specific hero's statistic information");
        this.setUsage("/hero admin stats \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero admin stats");
        this.setPermission("heroes.admin.stats");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return false;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        AttributeSet attributes = hero.getAttributes();
        if (attributes == null) {
            Heroes.log(Level.SEVERE, "Attributes are NULL for Hero: " + hero.getName() + ", with class: " + hero.getHeroClass() + ".");
            sender.sendMessage("There was an error when attempting to load your attribute statistics.");
            return false;
        }
        StatsInfoCommand.displayStatsInfo(sender, player, hero, attributes);
        return true;
    }
}

