/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.PeriodicStaminaEffect;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class AdminStaminaCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminStaminaCommand(Heroes plugin) {
        super("AdminStamina");
        this.plugin = plugin;
        this.setDescription("Restores a hero to full or partial stamina");
        this.setUsage("/hero admin stamina \u00a79<player> <percent(0.0-1.0)> <duration(ms)> <period(ms)>");
        this.setArgumentRange(0, 4);
        this.setIdentifiers("hero admin stamina");
        this.setPermission("heroes.admin.stamina");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (args.length > 0) {
            List players = this.plugin.getServer().matchPlayer(args[0]);
            if (players.isEmpty()) {
                sender.sendMessage(ChatColor.RED + "No player named " + args[0] + " was found!");
                return true;
            }
            double percent = 1.0;
            if (args.length > 1) {
                try {
                    percent = Double.parseDouble(args[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            long duration = 0L;
            if (args.length > 2) {
                try {
                    duration = Long.parseLong(args[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            long period = 0L;
            if (args.length > 3) {
                try {
                    period = Long.parseLong(args[3]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            StringBuilder names = new StringBuilder();
            for (int i = 0; i < players.size(); ++i) {
                Player player = (Player)players.get(i);
                Hero hero = this.plugin.getCharacterManager().getHero(player);
                double delta = percent * (double)hero.getMaxStamina();
                int amount = (int)Math.min(Math.max((double)hero.getStamina() + delta, 0.0), (double)hero.getMaxStamina());
                if (duration == 0L) {
                    hero.setStamina(amount);
                    player.sendMessage(ChatColor.GRAY + "The gods have restored your stamina!");
                } else {
                    AdminStaminaSkill staminaSkill = new AdminStaminaSkill(this.plugin);
                    ((ActiveSkill)staminaSkill).use(hero, new String[]{"" + period, "" + duration, "" + delta});
                }
                if (i > 0) {
                    names.append("  ");
                }
                names.append(player.getDisplayName());
            }
            sender.sendMessage(ChatColor.GRAY + "You have restored " + ChatColor.WHITE + names.toString() + ChatColor.GRAY + "'s stamina.");
            return true;
        }
        if (sender instanceof ConsoleCommandSender) {
            sender.sendMessage(ChatColor.RED + "You must specify a player to restore stamina to.");
            return true;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        hero.setStamina(hero.getMaxStamina());
        sender.sendMessage(ChatColor.GRAY + "Your stamina has been restored to full!");
        return true;
    }

    class AdminStaminaSkill
    extends ActiveSkill {
        public AdminStaminaSkill(Heroes plugin) {
            super(plugin, "AdminMana");
        }

        @Override
        public SkillResult use(Hero hero, String[] args) {
            long period = 0L;
            try {
                period = Long.parseLong(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            long duration = 0L;
            try {
                duration = Long.parseLong(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double delta = 0.0;
            try {
                delta = Double.parseDouble(args[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            hero.addEffect(new PeriodicStaminaEffect((Skill)this, "AdminStamina", hero.getPlayer(), period, duration, (int)delta));
            return SkillResult.NORMAL;
        }

        @Override
        public String getDescription(Hero hero) {
            return "";
        }
    }
}

