/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class AdminSkillVersionCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminSkillVersionCommand(Heroes plugin) {
        super("AdminSkillVersionCommand");
        this.plugin = plugin;
        this.setDescription("Gets the build version of a skill if available");
        this.setUsage("/hero admin skill version \u00a79<skill>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero admin skill version", "hero skill version");
        this.setPermission("heroes.admin.skill.version");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Skill skill = this.plugin.getSkillManager().getSkill(args[0]);
        if (skill == null) {
            sender.sendMessage(ChatColor.RED + "The skill '" + ChatColor.WHITE + args[0] + ChatColor.RED + "' does not exist.");
            return true;
        }
        String version = ChatColor.RED + "unknown";
        if (skill.hasVersion()) {
            version = ChatColor.BLUE + skill.getVersion();
        }
        sender.sendMessage(ChatColor.WHITE + skill.getName() + ChatColor.GRAY + "'s skill version: " + version);
        return true;
    }
}

