/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminSkillPrepareCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminSkillPrepareCommand(Heroes plugin) {
        super("AdminSkillPrepareCommand");
        this.plugin = plugin;
        this.setDescription("Set if a skill is prepared for a user");
        this.setUsage("/hero admin skill prepare \u00a79<player> <skill> <prepared>");
        this.setArgumentRange(3, 3);
        this.setIdentifiers("hero admin skill prepare");
        this.setPermission("heroes.admin.skill.prepare");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return true;
        }
        Skill skill = this.plugin.getSkillManager().getSkill(args[1]);
        if (skill == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching Skill for '" + args[2] + "'.");
            return true;
        }
        boolean prepare = Boolean.parseBoolean(args[2]);
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (prepare) {
            if (!hero.hasAccessToSkill(skill)) {
                sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " can not prepare the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " because none of their classes has the skill.");
                return true;
            }
            HeroSkill primary = hero.getHeroSkillForPrimary(skill);
            HeroSkill secondary = hero.getHeroSkillForSecondary(skill);
            HeroSkill race = hero.getHeroSkillForSecondary(skill);
            HeroSkill global = hero.getHeroSkillForGlobal(skill);
            if (!(primary != null && primary.getClassSkill().preparedUse() || secondary != null && secondary.getClassSkill().preparedUse() || race != null && race.getClassSkill().preparedUse() || global != null && global.getClassSkill().preparedUse())) {
                sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " can not prepare the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " because the skill does not need to be prepared.");
                return true;
            }
            if (hero.isSkillPrepared(skill)) {
                sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " already has the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " prepared.");
                return true;
            }
            if (!hero.canUseSkill(skill, true, true)) {
                sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " can not prepare the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " due to their class(s) not being high enough level.");
                return true;
            }
            if (!hero.canUseSkill(skill, true, false, true)) {
                sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " can not prepare the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " due to not have the skill learned.");
                return true;
            }
            if (hero.getPreparedSkillCount() >= hero.getPreparedSkillLimit()) {
                sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " can not prepare the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " having reached the max number of prepared skills.");
                return true;
            }
            if (!hero.hasSkillPreparePointsRemaining(hero.getSkillPrepareCost(skill).getAsInt())) {
                sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " can not prepare the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " due to not having enough remaining skill prepare points.");
                return true;
            }
            hero.adminPrepareSkill(skill);
            sender.sendMessage(ChatColor.YELLOW + "Skill has been prepared.");
            return true;
        }
        if (!hero.isSkillPrepared(skill)) {
            sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " already has the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " unprepared.");
            return true;
        }
        hero.unprepareSkill(skill);
        sender.sendMessage(ChatColor.YELLOW + "Skill has been unprepared.");
        return true;
    }
}

