/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminSkillLevelCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminSkillLevelCommand(Heroes plugin) {
        super("AdminSkillLevelCommand");
        this.plugin = plugin;
        this.setDescription("Set the level of a skill for a users class");
        this.setUsage("/hero admin skill level \u00a79<player> <class> <skill> <level>");
        this.setArgumentRange(4, 4);
        this.setIdentifiers("hero admin skill level");
        this.setPermission("heroes.admin.skill.level");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return true;
        }
        HeroClass heroClass = this.plugin.getClassManager().getClass(args[1]);
        if (heroClass == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching HeroClass for '" + args[1] + "'.");
            return true;
        }
        Skill skill = this.plugin.getSkillManager().getSkill(args[2]);
        if (skill == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching Skill for '" + args[2] + "'.");
            return true;
        }
        if (!heroClass.hasSkill(skill.getName())) {
            sender.sendMessage(ChatColor.RED + "Heroclass '" + args[1] + "' does not have the skill '" + args[2] + "'.");
            return true;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroSkill heroSkill = hero.getHeroSkillForClass(heroClass, skill);
        try {
            int levelChange = Integer.parseInt(args[2]);
            if (levelChange < 1) {
                throw new NumberFormatException();
            }
            heroSkill.adminSetLevel(levelChange);
            sender.sendMessage(ChatColor.YELLOW + "Skill level changed.");
            return true;
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + "Invalid level value.");
            return false;
        }
    }
}

