/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminSkillLearnCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminSkillLearnCommand(Heroes plugin) {
        super("AdminSkillLearnCommand");
        this.plugin = plugin;
        this.setDescription("Set if a skill is learned for a users class");
        this.setUsage("/hero admin skill learn \u00a79<player> <class> <skill> <learned>");
        this.setArgumentRange(4, 4);
        this.setIdentifiers("hero admin skill learn");
        this.setPermission("heroes.admin.skill.learn");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return true;
        }
        HeroClass heroClass = this.plugin.getClassManager().getClass(args[1]);
        if (heroClass == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching HeroClass for '" + args[1] + "'.");
            return true;
        }
        Skill skill = this.plugin.getSkillManager().getSkill(args[2]);
        if (skill == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching Skill for '" + args[2] + "'.");
            return true;
        }
        boolean learn = Boolean.parseBoolean(args[3]);
        if (!heroClass.hasSkill(skill.getName())) {
            sender.sendMessage(ChatColor.RED + "Heroclass '" + args[1] + "' does not have the skill '" + args[2] + "'.");
            return true;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroSkill heroSkill = hero.getHeroSkillForClass(heroClass, skill);
        if (!heroSkill.getClassSkill().learnedUse()) {
            sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " can not learn the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " for the class " + ChatColor.WHITE + heroClass.getName() + ChatColor.RED + "because the skill does not need to be learned.");
            return true;
        }
        if (learn) {
            if (heroSkill.isLearned()) {
                sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " already has the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " learned for the class " + ChatColor.WHITE + heroClass.getName() + ChatColor.RED + ".");
                return true;
            }
            if (hero.getHeroLevel(heroSkill.getHeroClass()) < heroSkill.getClassSkill().getUseLevel()) {
                sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " can not learn the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " for the class " + ChatColor.WHITE + heroClass.getName() + ChatColor.RED + "because they are to low level.");
                return true;
            }
            heroSkill.adminLearn();
            sender.sendMessage(ChatColor.YELLOW + "Skill has been learned for " + heroClass.getName() + ".");
            return true;
        }
        if (!heroSkill.isLearned()) {
            sender.sendMessage(ChatColor.WHITE + player.getName() + ChatColor.RED + " already has the skill " + ChatColor.WHITE + skill.getName() + ChatColor.RED + " not learned for the class " + ChatColor.WHITE + heroClass.getName() + ChatColor.RED + ".");
            return true;
        }
        heroSkill.unlearn();
        sender.sendMessage(ChatColor.YELLOW + "Skill has been unlearned for " + heroClass.getName() + ".");
        return true;
    }
}

