/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.PeriodicShieldEffect;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class AdminShieldCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminShieldCommand(Heroes plugin) {
        super("AdminShield");
        this.plugin = plugin;
        this.setDescription("Restores a hero to full or partial shield");
        this.setUsage("/hero admin shield \u00a79<player> [percent(0.0-1.0)] [duration(ms)] [period(ms)]");
        this.setArgumentRange(0, 4);
        this.setIdentifiers("hero admin shield");
        this.setPermission("heroes.admin.shield");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (args.length > 0) {
            List players = this.plugin.getServer().matchPlayer(args[0]);
            if (players.isEmpty()) {
                sender.sendMessage(ChatColor.RED + "No player named " + args[0] + " was found!");
                return true;
            }
            float percent = 1.0f;
            if (args.length > 1) {
                try {
                    percent = Float.parseFloat(args[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            long duration = 0L;
            if (args.length > 2) {
                try {
                    duration = Long.parseLong(args[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            long period = 0L;
            if (args.length > 3) {
                try {
                    period = Long.parseLong(args[3]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            StringBuilder names = new StringBuilder();
            for (int i = 0; i < players.size(); ++i) {
                Player player = (Player)players.get(i);
                Hero hero = this.plugin.getCharacterManager().getHero(player);
                float delta = percent * (float)hero.getMaxShield();
                int amount = (int)Math.min(Math.max(hero.getShield() + delta, 0.0f), (float)hero.getMaxShield());
                if (duration == 0L) {
                    hero.setShield(amount);
                    player.sendMessage(ChatColor.GRAY + "The gods have restored your shield!");
                } else {
                    AdminShieldSkill shieldSkill = new AdminShieldSkill(this.plugin);
                    ((ActiveSkill)shieldSkill).use(hero, new String[]{"" + period, "" + duration, "" + delta});
                }
                if (i > 0) {
                    names.append("  ");
                }
                names.append(player.getDisplayName());
            }
            sender.sendMessage(ChatColor.GRAY + "You have restored " + ChatColor.WHITE + names.toString() + ChatColor.GRAY + "'s shield.");
            return true;
        }
        if (sender instanceof ConsoleCommandSender) {
            sender.sendMessage(ChatColor.RED + "You must specify a player to restore shield to.");
            return true;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        hero.setShield(hero.getMaxShield());
        player.sendMessage(ChatColor.GRAY + "Your shield has been fully restored!");
        return true;
    }

    class AdminShieldSkill
    extends ActiveSkill {
        public AdminShieldSkill(Heroes plugin) {
            super(plugin, "AdminShield");
        }

        @Override
        public SkillResult use(Hero hero, String[] args) {
            long period = 0L;
            try {
                period = Long.parseLong(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            long duration = 0L;
            try {
                duration = Long.parseLong(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int delta = 0;
            try {
                delta = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            hero.addEffect(new PeriodicShieldEffect((Skill)this, "AdminShield", hero.getPlayer(), period, duration, delta));
            return SkillResult.NORMAL;
        }

        @Override
        public String getDescription(Hero hero) {
            return "";
        }
    }
}

