/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.AfterClassChangeEvent;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AdminResetRaceCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminResetRaceCommand(Heroes plugin) {
        super("AdminResetRaceCommand");
        this.plugin = plugin;
        this.setDescription("Changes a users race");
        this.setUsage("/hero admin resetrace \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero admin resetrace");
        this.setPermission("heroes.admin.resetrace");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return true;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroClass currentRace = hero.getRaceClass();
        HeroClass defaultRace = this.plugin.getClassManager().getDefaultRace();
        ClassChangeEvent event = new ClassChangeEvent(hero, currentRace, defaultRace, 0.0, false, true);
        Bukkit.getPluginManager().callEvent((Event)event);
        hero.setHeroClass(defaultRace, false, true);
        this.plugin.getCharacterManager().performSkillChecks(hero);
        String raceName = defaultRace != null ? ChatColor.WHITE + defaultRace.getName() : "raceless";
        sender.sendMessage(ChatColor.GRAY + "You have successfully reset " + ChatColor.WHITE + player.getName() + ChatColor.GRAY + "'s race to " + raceName + ChatColor.GRAY + ".");
        if (defaultRace != null) {
            player.sendMessage(ChatColor.GRAY + "You are reborn as a " + raceName + ChatColor.GREEN + "!");
        } else {
            player.sendMessage(ChatColor.GRAY + "You are reborn " + raceName + ChatColor.GREEN + "!");
        }
        this.plugin.getCharacterManager().saveHero(hero, false);
        AfterClassChangeEvent afterEvent = new AfterClassChangeEvent(hero, currentRace, defaultRace, 0.0, false, true);
        this.plugin.getServer().getPluginManager().callEvent((Event)afterEvent);
        return true;
    }
}

