/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.AfterClassChangeEvent;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AdminRaceCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminRaceCommand(Heroes plugin) {
        super("AdminClassCommand");
        this.plugin = plugin;
        this.setDescription("Changes a users race");
        this.setUsage("/hero admin race \u00a79<player> <race>");
        this.setArgumentRange(2, 2);
        this.setIdentifiers("hero admin race");
        this.setPermission("heroes.admin.race");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return true;
        }
        HeroClass heroClass = this.plugin.getClassManager().getClass(args[1]);
        if (heroClass == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching HeroClass for '" + args[1] + "'.");
            return true;
        }
        if (!heroClass.isRace()) {
            sender.sendMessage(ChatColor.RED + args[1] + " is not a race!");
            return true;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (heroClass.equals(hero.getRaceClass())) {
            sender.sendMessage(ChatColor.RED + player.getName() + " is already a " + heroClass.getName());
            return true;
        }
        ClassChangeEvent event = new ClassChangeEvent(hero, hero.getRaceClass(), heroClass, 0.0, false, false);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            sender.sendMessage(ChatColor.RED + "Failed to set the player to that class due to class restrictions.");
            return true;
        }
        hero.changeHeroClass(heroClass, false, true);
        sender.sendMessage(ChatColor.GRAY + "You have successfully changed " + ChatColor.WHITE + player.getName() + ChatColor.GRAY + "'s HeroClass to " + ChatColor.WHITE + heroClass.getName() + ChatColor.GRAY + ".");
        player.sendMessage(ChatColor.GRAY + "You have been reborn as a " + ChatColor.WHITE + heroClass.getName() + ChatColor.GRAY + "!");
        AfterClassChangeEvent afterEvent = new AfterClassChangeEvent(hero, hero.getRaceClass(), heroClass, 0.0, false, false);
        this.plugin.getServer().getPluginManager().callEvent((Event)afterEvent);
        return true;
    }
}

