/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.command.commands.ProgressInfoCommand;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminProgressInfoCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminProgressInfoCommand(Heroes plugin) {
        super("View a Player's Progress Information");
        this.plugin = plugin;
        this.setDescription("Displays a specific hero's progress information");
        this.setUsage("/hero admin progress \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero admin progress");
        this.setPermission("heroes.admin.progress");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return false;
        }
        Set<HeroClass> loadedClasses = this.plugin.getClassManager().getClasses();
        if (loadedClasses == null) {
            Heroes.log(Level.SEVERE, "Hero classes are NULL.");
            sender.sendMessage("There was an error when attempting to load your classes information.");
            return false;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        ArrayList<HeroClass> leveledClasses = new ArrayList<HeroClass>();
        for (HeroClass heroClass : loadedClasses) {
            if (!(hero.getExperience(heroClass) > 0.0)) continue;
            leveledClasses.add(heroClass);
        }
        if (leveledClasses.isEmpty()) {
            sender.sendMessage("No leveled class progress to display!");
        } else {
            ProgressInfoCommand.displayClassesInfo(sender, leveledClasses, hero);
        }
        return true;
    }
}

