/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.AfterClassChangeEvent;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AdminProfCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminProfCommand(Heroes plugin) {
        super("AdminClassCommand");
        this.plugin = plugin;
        this.setDescription("Changes a users secondary class");
        this.setUsage("/hero admin prof \u00a79<player> <class>");
        this.setArgumentRange(2, 2);
        this.setIdentifiers("hero admin prof");
        this.setPermission("heroes.admin.prof");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return true;
        }
        HeroClass heroClass = this.plugin.getClassManager().getClass(args[1]);
        if (heroClass == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching HeroClass for '" + args[1] + "'.");
            return true;
        }
        if (!heroClass.isSecondary()) {
            sender.sendMessage(ChatColor.RED + args[1] + " is not a secondary class!");
            return true;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (heroClass.equals(hero.getSecondaryClass())) {
            sender.sendMessage(ChatColor.RED + player.getName() + " is already a " + heroClass.getName());
            return true;
        }
        HeroClass previousHeroClass = hero.getSecondaryClass();
        ClassChangeEvent event = new ClassChangeEvent(hero, previousHeroClass, heroClass, 0.0, false, false);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            sender.sendMessage(ChatColor.RED + "Failed to set the player to that class due to class restrictions.");
            return true;
        }
        hero.changeHeroClass(heroClass, true, false);
        sender.sendMessage(ChatColor.GRAY + "You have successfully changed " + ChatColor.WHITE + player.getName() + ChatColor.GRAY + "'s HeroClass to " + ChatColor.WHITE + heroClass.getName() + ChatColor.GRAY + ".");
        player.sendMessage(ChatColor.GRAY + "Welcome to the path of the " + ChatColor.WHITE + heroClass.getName() + ChatColor.GRAY + "!");
        AfterClassChangeEvent afterEvent = new AfterClassChangeEvent(hero, previousHeroClass, heroClass, 0.0, false, false);
        this.plugin.getServer().getPluginManager().callEvent((Event)afterEvent);
        return true;
    }
}

