/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminNPCCommand
extends BasicCommand {
    private Heroes plugin;

    public AdminNPCCommand(Heroes plugin) {
        super("AdminNPCCommand");
        this.setDescription("Sets selected (/npc select) NPC's class levels");
        this.setUsage("/hero admin npc [class|prof] [classname] [level]");
        this.setArgumentRange(3, 3);
        this.setIdentifiers("hero admin npc");
        this.setPermission("heroes.admin.npc.class");
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        NPC selected = ((Citizens)CitizensAPI.getPlugin()).getNPCSelector().getSelected(sender);
        if (selected == null) {
            Messaging.send((CommandSender)player, "You have no NPCs selected!", new Object[0]);
            return true;
        }
        if (!(selected.getEntity() instanceof Player)) {
            Messaging.send((CommandSender)player, "Setting classes on non-player NPCs is not supported at this time", new Object[0]);
            return true;
        }
        HeroClass hc = this.plugin.getClassManager().getClass(args[1]);
        try {
            int level = Integer.parseInt(args[2]);
            if (hc != null) {
                boolean primary = false;
                if (args[0].equalsIgnoreCase("class")) {
                    primary = true;
                } else if (args[0].equalsIgnoreCase("prof")) {
                    primary = false;
                } else {
                    return false;
                }
                Hero hero = this.plugin.getCharacterManager().getHero((Player)selected.getEntity());
                if (hc.isPrimary() == primary) {
                    hero.setHeroClass(hc, !primary, false);
                    if (level < 1) {
                        throw new NumberFormatException();
                    }
                    int experience = Properties.levels[level - 1];
                    hero.addExp((double)experience - hero.getExperience(hc), hc, hero.getPlayer().getLocation());
                    this.plugin.getCharacterManager().saveHero(hero, false);
                    Messaging.send(sender, "Level changed.", new Object[0]);
                    return true;
                }
                sender.sendMessage(args[1] + " is not a class of matching type");
                return false;
            }
            sender.sendMessage("Class " + args[1] + " not found!");
            return false;
        }
        catch (NumberFormatException e) {
            Messaging.send(sender, "Invalid level value.", new Object[0]);
            return false;
        }
    }
}

