/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Properties;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminLevelCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminLevelCommand(Heroes plugin) {
        super("AdminLevelCommand");
        this.plugin = plugin;
        this.setDescription("Changes a users level");
        this.setUsage("/hero admin level \u00a79<player> <class> <level>");
        this.setArgumentRange(3, 3);
        this.setIdentifiers("hero admin level");
        this.setPermission("heroes.admin.level");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return false;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroClass hc = this.plugin.getClassManager().getClass(args[1]);
        if (hc == null) {
            if (args[1].equalsIgnoreCase("prim")) {
                hc = hero.getHeroClass();
            } else if (args[1].equalsIgnoreCase("prof")) {
                hc = hero.getSecondaryClass();
            } else if (args[1].equalsIgnoreCase("prof")) {
                hc = hero.getRaceClass();
            }
        }
        if (hc == null) {
            sender.sendMessage(ChatColor.RED + args[1] + " is not a valid HeroClass!");
            return false;
        }
        try {
            int levelChange = Integer.parseInt(args[2]);
            if (levelChange < 1) {
                throw new NumberFormatException();
            }
            int experience = Properties.levels[levelChange - 1];
            hero.addExp((double)experience - hero.getExperience(hc), hc, hero.getPlayer().getLocation());
            sender.sendMessage(ChatColor.YELLOW + "Level changed.");
            return true;
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + "Invalid level value.");
            return false;
        }
    }
}

