/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.PeriodicHealEffect;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class AdminHealCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminHealCommand(Heroes plugin) {
        super("AdminHeal");
        this.plugin = plugin;
        this.setDescription("Heals a hero to full or partial health");
        this.setUsage("/hero admin heal \u00a79<player> <percent(0.0-1.0)> <duration(ms)> <period(ms)>");
        this.setArgumentRange(0, 4);
        this.setIdentifiers("hero admin heal");
        this.setPermission("heroes.admin.heal");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (args.length > 0) {
            List players = this.plugin.getServer().matchPlayer(args[0]);
            if (players.isEmpty()) {
                sender.sendMessage(ChatColor.RED + "No player named " + args[0] + " was found!");
                return true;
            }
            double percent = 1.0;
            if (args.length > 1) {
                try {
                    percent = Double.parseDouble(args[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            long duration = 0L;
            if (args.length > 2) {
                try {
                    duration = Long.parseLong(args[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            long period = 0L;
            if (args.length > 3) {
                try {
                    period = Long.parseLong(args[3]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            StringBuilder names = new StringBuilder();
            for (int i = 0; i < players.size(); ++i) {
                Player player = (Player)players.get(i);
                double delta = percent * player.getMaxHealth();
                double amount = Math.min(Math.max(player.getHealth() + delta, 0.0), player.getMaxHealth());
                if (duration == 0L) {
                    player.setHealth(amount);
                    player.sendMessage(ChatColor.GRAY + "The gods have miraculously healed you!");
                } else {
                    AdminHealSkill healSkill = new AdminHealSkill(this.plugin);
                    ((ActiveSkill)healSkill).use(this.plugin.getCharacterManager().getHero(player), new String[]{"" + period, "" + duration, "" + delta});
                }
                if (i > 0) {
                    names.append("  ");
                }
                names.append(player.getDisplayName());
            }
            sender.sendMessage(ChatColor.GRAY + "You have restored " + ChatColor.WHITE + names.toString() + ChatColor.GRAY + "'s health.");
            return true;
        }
        if (sender instanceof ConsoleCommandSender) {
            sender.sendMessage(ChatColor.RED + "You must specify a player to heal.");
            return true;
        }
        Player player = (Player)sender;
        player.setHealth(player.getMaxHealth());
        player.sendMessage(ChatColor.GRAY + "You have been restored to full health!");
        return true;
    }

    class AdminHealSkill
    extends ActiveSkill {
        public AdminHealSkill(Heroes plugin) {
            super(plugin, "AdminHeal");
        }

        @Override
        public SkillResult use(Hero hero, String[] args) {
            long period = 0L;
            try {
                period = Long.parseLong(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            long duration = 0L;
            try {
                duration = Long.parseLong(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double delta = 0.0;
            try {
                delta = Double.parseDouble(args[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            hero.addEffect(new PeriodicHealEffect((Skill)this, "AdminHeal", hero.getPlayer(), period, duration, delta));
            return SkillResult.NORMAL;
        }

        @Override
        public String getDescription(Hero hero) {
            return "";
        }
    }
}

