/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminExpCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminExpCommand(Heroes plugin) {
        super("AdminExpCommand");
        this.plugin = plugin;
        this.setDescription("Changes a users class exp");
        this.setUsage("/hero admin exp \u00a79<player> <class> <exp> [allow-in-combat]");
        this.setArgumentRange(3, 4);
        this.setIdentifiers("hero admin exp");
        this.setPermission("heroes.admin.exp");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        double expChange;
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return false;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroClass hc = this.plugin.getClassManager().getClass(args[1]);
        if (hc == null) {
            if (args[1].equalsIgnoreCase("prim")) {
                hc = hero.getHeroClass();
            } else if (args[1].equalsIgnoreCase("prof")) {
                hc = hero.getSecondaryClass();
            } else if (args[1].equalsIgnoreCase("race")) {
                hc = hero.getRaceClass();
            }
        }
        if (hc == null) {
            sender.sendMessage(ChatColor.RED + args[1] + " is not a valid HeroClass!");
            return false;
        }
        try {
            expChange = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + "Invalid experience value.");
            return false;
        }
        if (args.length > 3) {
            if (args[3].equalsIgnoreCase("true") || args[3].equalsIgnoreCase("false")) {
                boolean allowInCombat = Boolean.parseBoolean(args[3]);
                if (!allowInCombat && hero.isInCombat()) {
                    hero.getPlayer().sendMessage(ChatColor.RED + "You cannot be awarded this exp in combat.");
                    return false;
                }
            } else {
                sender.sendMessage(ChatColor.RED + "Invalid allow-in-combat value. Use \"true\" to allow exp gain in combat or \"false\" to disable.");
                return false;
            }
        }
        hero.addExp(expChange, hc, hero.getPlayer().getLocation());
        this.plugin.getCharacterManager().saveHero(hero, false);
        sender.sendMessage(ChatColor.GRAY + "Experience changed.");
        hero.getPlayer().sendMessage(ChatColor.GRAY + "You have been awarded " + ChatColor.WHITE + expChange + ChatColor.GRAY + " exp");
        return true;
    }
}

