/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.listeners.ExpBoostListener;
import com.herocraftonline.heroes.util.Util;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AdminExpBoostReloadCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminExpBoostReloadCommand(Heroes plugin) {
        super("AdminExpBoostReload");
        this.plugin = plugin;
        this.setDescription("Reloads the players exp boost state from perms");
        this.setUsage("/hero admin expboost reload \u00a79<player> [delay s]");
        this.setArgumentRange(0, 2);
        this.setIdentifiers("hero admin expboost reload");
        this.setPermission("heroes.admin.expboost.reload");
    }

    @Override
    public boolean execute(final CommandSender sender, String identifier, String[] args) {
        if (args.length > 0) {
            final Player player = Bukkit.getServer().getPlayer(args[0]);
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "No player named " + args[0] + " was found!");
                return true;
            }
            int delaySeconds = 0;
            if (args.length > 1) {
                Integer tempInt = Util.toInt(args[1]);
                if (tempInt == null || tempInt < 0) {
                    sender.sendMessage(ChatColor.RED + "Invalid delay in seconds: '" + args[1] + "'. Must be numeric and greater than or equal 0!");
                    return false;
                }
                delaySeconds = tempInt;
            }
            if (delaySeconds > 0) {
                new BukkitRunnable(){

                    public void run() {
                        ExpBoostListener.reloadBoost(player);
                        if (sender instanceof Player && ((Player)sender).isOnline()) {
                            sender.sendMessage(ChatColor.GRAY + "After delay, reloaded " + ChatColor.WHITE + player.getDisplayName() + ChatColor.GRAY + "'s exp boost from perms.");
                        } else {
                            Heroes.log(Level.INFO, ChatColor.GRAY + "After delay, reloaded " + ChatColor.WHITE + player.getDisplayName() + ChatColor.GRAY + "'s exp boost from perms.");
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, (long)(delaySeconds * 20));
            } else {
                ExpBoostListener.reloadBoost(player);
                sender.sendMessage(ChatColor.GRAY + "Reloaded " + ChatColor.WHITE + player.getDisplayName() + ChatColor.GRAY + "'s exp boost from perms.");
            }
            return true;
        }
        ExpBoostListener.reloadAllBoosts();
        sender.sendMessage(ChatColor.RED + "Reloaded all players exp boosts from perms.");
        return true;
    }
}

