/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.command.commands.BoostCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminExpBoostInfoCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminExpBoostInfoCommand(Heroes plugin) {
        super("AdminExpBoostInfoCommand");
        this.plugin = plugin;
        this.setDescription("Gets bonus exp info of a player. Admin equivalent to a player using /boost");
        this.setUsage("/hero admin expboost info \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero admin expboost info");
        this.setPermission("heroes.admin.expboost.info");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return false;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        BoostCommand.showBoostInfo(sender, hero);
        return true;
    }
}

