/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.common.ExpBoostEffect;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminExpBoostCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminExpBoostCommand(Heroes plugin) {
        super("AdminExpBoostCommand");
        this.plugin = plugin;
        this.setDescription("Grants bonus exp to player for certain amount of minutes.");
        this.setUsage("/hero admin expboost \u00a79<player> <boost %> <minutes> [stack-with-perms=true]");
        this.setArgumentRange(3, 4);
        this.setIdentifiers("hero admin expboost");
        this.setPermission("heroes.admin.expboost");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return false;
        }
        String boostPercentString = args[1];
        Integer boostPercentageInt = Util.toInt(args[1]);
        if (boostPercentageInt == null || boostPercentageInt <= 0) {
            sender.sendMessage(ChatColor.RED + "Invalid boost percentage: '" + boostPercentString + "'. Must be numeric and greater than 0!");
            return false;
        }
        int boostPercentage = boostPercentageInt;
        Integer minutesInt = Util.toInt(args[2]);
        if (minutesInt == null || minutesInt <= 0) {
            sender.sendMessage(ChatColor.RED + "Invalid duration in minutes: '" + boostPercentString + "'. Must be numeric and greater than 0!");
            return false;
        }
        int minutes = minutesInt;
        boolean stackWithBoostPerms = true;
        if (args.length > 3) {
            stackWithBoostPerms = Boolean.getBoolean(args[2]);
        }
        long duration = minutes * 60 * 1000;
        double expMultiplier = 1.0 + (double)boostPercentage / 100.0;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        hero.addEffect(new ExpBoostEffect(null, duration, expMultiplier, stackWithBoostPerms));
        sender.sendMessage(ChatColor.GRAY + "Successfully granted " + ChatColor.WHITE + boostPercentage + ChatColor.GRAY + "% exp boost to " + player.getName() + " for " + minutes + " minutes.");
        return true;
    }
}

