/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class AdminCooldownCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminCooldownCommand(Heroes plugin) {
        super("AdminCooldown");
        this.plugin = plugin;
        this.setDescription("Resets a heros cooldowns");
        this.setUsage("/hero admin cooldown \u00a79<player>");
        this.setArgumentRange(0, 3);
        this.setIdentifiers("hero admin cooldown");
        this.setPermission("heroes.admin.cooldown");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (args.length > 0) {
            List players = this.plugin.getServer().matchPlayer(args[0]);
            if (players.isEmpty()) {
                sender.sendMessage(ChatColor.RED + "No player named " + args[0] + " was found!");
                return true;
            }
            StringBuilder names = new StringBuilder();
            for (Player player : players) {
                Hero hero = this.plugin.getCharacterManager().getHero(player);
                Map<String, Long> cooldowns = hero.getCooldowns();
                if (cooldowns.isEmpty()) continue;
                for (String cooldown : cooldowns.keySet()) {
                    hero.removeCooldown(cooldown);
                }
                sender.sendMessage(ChatColor.GRAY + "The gods have miraculously removed your skill cooldowns!");
                names.append(player.getDisplayName()).append("  ");
            }
            sender.sendMessage(ChatColor.RED + "You have reset the cooldowns of: " + ChatColor.WHITE + names.toString());
            return true;
        }
        if (sender instanceof ConsoleCommandSender) {
            sender.sendMessage(ChatColor.RED + "You must specifiy a player to reset.");
            return true;
        }
        Player player = (Player)sender;
        Map<String, Long> cooldowns = this.plugin.getCharacterManager().getHero(player).getCooldowns();
        if (cooldowns.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "You have no cooldowns!");
            return true;
        }
        for (String cooldown : cooldowns.keySet()) {
            this.plugin.getCharacterManager().getHero(player).removeCooldown(cooldown);
        }
        sender.sendMessage(ChatColor.RED + "You have reset your cooldowns!");
        return true;
    }
}

