/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.command.BasicCommand;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class AdminBonusCommand
extends BasicCommand {
    private final DateFormat dateFormatter = new SimpleDateFormat("MM.dd HH:mm");

    public AdminBonusCommand(Heroes plugin) {
        super("AdminBonusCommand");
        this.setDescription("Grants bonus exp based on time, duration and multiplier");
        this.setUsage("/hero bonus \u00a79<time|addtime|message|exp-mult> <value>");
        this.setArgumentRange(2, 1000);
        this.setIdentifiers("hero bonus");
        this.setPermission("heroes.admin.bonus");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (args[0].equalsIgnoreCase("time")) {
            this.time(sender, args[1], false);
        } else if (args[0].equalsIgnoreCase("addtime")) {
            this.time(sender, args[1], true);
        } else if (args[0].equalsIgnoreCase("message")) {
            this.messageChange(sender, args);
        } else if (args[0].equalsIgnoreCase("exp-mult")) {
            this.expMult(sender, args[1]);
        } else {
            sender.sendMessage(this.getUsage());
        }
        return true;
    }

    private void time(CommandSender sender, String arg, boolean addtime) {
        GregorianCalendar cal = new GregorianCalendar();
        Integer field = null;
        Pattern pattern = Pattern.compile("(?i)(\\d+)(.+)", 2);
        Matcher matcher = pattern.matcher(arg);
        if (matcher.find()) {
            int amount = 0;
            try {
                amount = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + "Invalid timing given for exp bonus");
                return;
            }
            arg = matcher.group(2);
            if (arg.equalsIgnoreCase("min")) {
                field = 12;
            } else if (arg.equalsIgnoreCase("s")) {
                field = 13;
            } else if (arg.equalsIgnoreCase("h")) {
                field = 11;
            } else if (arg.equalsIgnoreCase("d")) {
                field = 6;
            } else if (arg.equalsIgnoreCase("w")) {
                field = 3;
            } else if (arg.equalsIgnoreCase("m")) {
                field = 2;
            }
            if (field == null) {
                sender.sendMessage(ChatColor.RED + "Invalid time-type given, use: min - Minutes, s - Seconds, h - Hours, d - Days, w - Weeks, m - Month");
                return;
            }
            if (addtime && System.currentTimeMillis() < Heroes.properties.expiration) {
                cal.setTimeInMillis(Heroes.properties.expiration);
                ((Calendar)cal).add(field, amount);
                Heroes.properties.expiration = cal.getTimeInMillis();
                sender.sendMessage(ChatColor.GRAY + "You have increased the bonus expiration to: " + ChatColor.WHITE + this.dateFormatter.format(cal.getTime()));
            } else {
                ((Calendar)cal).add(field, amount);
                Heroes.properties.expiration = cal.getTimeInMillis();
                sender.sendMessage(ChatColor.GRAY + "You have reset the bonus expiration to: " + ChatColor.WHITE + this.dateFormatter.format(cal.getTime()));
            }
        } else {
            sender.sendMessage(ChatColor.GRAY + "Current bonus expiration is set to: " + ChatColor.WHITE + this.dateFormatter.format(new Date(Heroes.properties.expiration)));
            return;
        }
        Heroes.properties.saveConfig();
    }

    private void expMult(CommandSender sender, String arg) {
        try {
            Heroes.properties.expBonus = Double.valueOf(arg);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + arg + " is not a valid exp multiplier");
            return;
        }
        sender.sendMessage(ChatColor.GRAY + "The experience bonus was set to " + ChatColor.WHITE + Heroes.properties.expBonus);
        Heroes.properties.saveConfig();
    }

    private void messageChange(CommandSender sender, String[] args) {
        StringBuilder msg = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            msg.append(args[i]).append(' ');
        }
        Heroes.properties.bonusMessage = msg.toString().trim();
        Heroes.properties.saveConfig();
        sender.sendMessage(ChatColor.GRAY + "Bonus message was set to: " + ChatColor.WHITE + msg.toString().trim());
    }
}

