/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.PassiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.EquipmentUtil;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Util;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminBindSkillCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminBindSkillCommand(Heroes plugin) {
        super("AdminBindSkill");
        this.plugin = plugin;
        this.setDescription("Binds a skill with a material for a player.");
        this.setUsage("/hero admin bind \u00a79<player> <material> <skill> \u00a78[args]");
        this.setArgumentRange(2, 1000);
        this.setIdentifiers("hero admin bind", "hero admin unbind");
        this.setPermission("heroes.admin.bind");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return false;
        }
        Material material = Material.matchMaterial((String)args[1]);
        if (material == null) {
            sender.sendMessage(ChatColor.RED + "Invalid material name '" + args[1] + "'. Make sure to use names not ids, e.g. IRON_INGOT.");
            return false;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (Util.isWeapon(material) && !hero.isAllowedWeapon(hero.getHeroClass(), material) && !hero.isAllowedWeapon(hero.getSecondaryClass(), material) && !hero.isAllowedWeapon(hero.getRaceClass(), material)) {
            sender.sendMessage(EquipmentUtil.getCannotUseWeaponMessage(hero, material));
            return false;
        }
        if (args.length > 2 && !identifier.equals("hero admin unbind")) {
            Skill skill = this.plugin.getSkillManager().getSkill(args[2]);
            if (skill == null) {
                skill = this.plugin.getSkillManager().getSkillFromIdent("skill " + args[2], sender);
            }
            if (skill != null && hero.canUseSkill(skill.getName())) {
                if (skill instanceof PassiveSkill || skill instanceof OutsourcedSkill) {
                    sender.sendMessage(ChatColor.RED + "You can not bind passive skills!");
                    return false;
                }
                if (skill.isType(SkillType.UNBINDABLE)) {
                    sender.sendMessage(ChatColor.RED + "You can not bind that skill!");
                    return false;
                }
                if (material == Material.AIR) {
                    sender.sendMessage(ChatColor.RED + "You cannot bind a skill to air!");
                    return false;
                }
                hero.bind(material, Arrays.copyOfRange(args, 2, args.length));
                sender.sendMessage(ChatColor.WHITE + MaterialUtil.getFriendlyName(material) + ChatColor.GRAY + " has been bound to " + ChatColor.WHITE + skill.getName() + ChatColor.GRAY + " for " + ChatColor.WHITE + player.getName() + ChatColor.GRAY + ".");
            } else {
                sender.sendMessage(ChatColor.RED + (hero.hasAccessToSkill(skill) ? "The player can not currently use that skill." : "That skill does not exist for the player's class."));
            }
        } else {
            hero.unbind(material);
            sender.sendMessage(ChatColor.YELLOW + MaterialUtil.getFriendlyName(material) + " is no longer bound to a skill.");
        }
        return true;
    }
}

