/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminAttributeSetCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminAttributeSetCommand(Heroes plugin) {
        super("AdminAttributeSetCommand");
        this.plugin = plugin;
        this.setDescription("Sets a player's specific attribute to the specified value.");
        this.setUsage("/hero admin attribute set \u00a79<player> <attribute> <value>");
        this.setArgumentRange(3, 3);
        this.setIdentifiers("hero admin attribute set");
        this.setPermission("heroes.admin.attribute.set");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return true;
        }
        AttributeType type = AttributeType.matchAttribute(args[1]);
        if (type == null) {
            player.sendMessage(ChatColor.RED + "That Attribute does not exist!");
            return false;
        }
        try {
            int setToAmount = Integer.parseInt(args[2]);
            if (setToAmount < Integer.MIN_VALUE) {
                player.sendMessage(ChatColor.RED + "You can't set this player's attribute that low!");
                return false;
            }
            if (setToAmount > Integer.MAX_VALUE) {
                player.sendMessage(ChatColor.RED + "You can't set this player's attribute that high!");
                return false;
            }
            Hero hero = this.plugin.getCharacterManager().getHero(player);
            hero.setAllocatedAttribute(type, setToAmount);
            return true;
        }
        catch (Exception e) {
            player.sendMessage(ChatColor.RED + "That is not a valid value to set an attribute to!");
            return false;
        }
    }
}

