/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Properties;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminAttributeResetCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminAttributeResetCommand(Heroes plugin) {
        super("AdminAttributeSetCommand");
        this.plugin = plugin;
        this.setDescription("Reset a specific player's allocated attributes.");
        this.setUsage("/hero admin attribute reset \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero admin attribute reset");
        this.setPermission("heroes.admin.attribute.reset");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return true;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroClass hc = hero.getHeroClass();
        int exp = (int)hero.getExperience(hc);
        int level = Properties.getLevel(exp);
        hero.clearClassAttributeAllocations();
        hero.setAllocationPoints((level - 1) * hc.getAllocationPointsPerLevel());
        player.sendMessage(ChatColor.GRAY + "Your attribute allocations have been reset!");
        return true;
    }
}

