/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminAllocationPointsCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminAllocationPointsCommand(Heroes plugin) {
        super("AdminAllocationPointsCommand");
        this.plugin = plugin;
        this.setDescription("Sets a user's allocation points to the specified value");
        this.setUsage("/hero admin allocationpoints \u00a79<player> <points>");
        this.setArgumentRange(2, 2);
        this.setIdentifiers("hero admin allocationpoints");
        this.setPermission("heroes.admin.allocationpoints");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Failed to find a matching player for '" + args[0] + ChatColor.RED + "'. Offline players are not supported!");
            return true;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        try {
            int allocationValue = Integer.parseInt(args[1]);
            if (hero.getAllocationPoints() == allocationValue) {
                throw new NumberFormatException();
            }
            if (hero.setAllocationPoints(hero.getHeroClass(), allocationValue)) {
                sender.sendMessage(ChatColor.GREEN + player.getName() + "'s allocation points have been set to " + allocationValue);
                return true;
            }
            throw new NumberFormatException();
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + "Invalid attribute allocation value.");
            return false;
        }
    }
}

