/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.Command;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler {
    private LinkedHashMap<String, Command> commands;
    private HashMap<String, Command> identifiers;
    private final Heroes plugin;

    public CommandHandler(Heroes plugin) {
        this.plugin = plugin;
        this.commands = new LinkedHashMap();
        this.identifiers = new HashMap();
    }

    public void addCommand(Command command) {
        this.commands.put(command.getName().toLowerCase(), command);
        for (String ident : command.getIdentifiers()) {
            this.identifiers.put(ident.toLowerCase(), command);
        }
    }

    public boolean dispatch(CommandSender sender, String commandName, String label, String[] args) {
        if (commandName.equals("skill")) {
            this.dispatchSkill(sender, args);
            return true;
        }
        for (int argsIncluded = args.length; argsIncluded >= 0; --argsIncluded) {
            StringBuilder identifierBuilder = new StringBuilder(commandName);
            for (int i = 0; i < argsIncluded; ++i) {
                identifierBuilder.append(' ').append(args[i]);
            }
            String identifier = identifierBuilder.toString();
            Command cmd = this.getCmdFromIdent(identifier, sender);
            if (cmd == null) continue;
            String[] realArgs = Arrays.copyOfRange(args, argsIncluded, args.length);
            if (!cmd.isInProgress(sender)) {
                if (realArgs.length < cmd.getMinArguments() || realArgs.length > cmd.getMaxArguments()) {
                    this.displayCommandHelp(cmd, sender);
                    return true;
                }
                if (realArgs.length > 0 && realArgs[0].equals("?")) {
                    this.displayCommandHelp(cmd, sender);
                    return true;
                }
            }
            if (!CommandHandler.hasPermission(sender, cmd.getPermission())) {
                sender.sendMessage(ChatColor.RED + "Insufficient permission.");
                return true;
            }
            cmd.execute(sender, identifier, realArgs);
            return true;
        }
        if (label.equalsIgnoreCase("skill")) {
            sender.sendMessage(ChatColor.RED + "That skill does not exist!");
        } else {
            sender.sendMessage(ChatColor.RED + "Unrecognized command!");
        }
        return true;
    }

    public Skill dispatchSkill(CommandSender sender, String[] args) {
        for (int included = args.length; included >= 0; --included) {
            StringBuilder identBuilder = new StringBuilder("skill");
            for (int i = 0; i < included; ++i) {
                identBuilder.append(' ').append(args[i]);
            }
            String identifier = identBuilder.toString();
            Skill skill = this.plugin.getSkillManager().getSkillFromIdent(identifier, sender);
            if (skill == null) continue;
            String[] trimmedArgs = Arrays.copyOfRange(args, included, args.length);
            skill.execute(sender, identifier, trimmedArgs);
            return skill;
        }
        return null;
    }

    public List<String> tabComplete(CommandSender sender, String command, String alias, String[] args) {
        if (command.equals("skill")) {
            return this.tabCompleteSkills(sender, args);
        }
        return null;
    }

    public List<String> tabCompleteSkills(CommandSender sender, String[] partialArgs) {
        if (!(sender instanceof Player)) {
            return null;
        }
        Player p = (Player)sender;
        Hero h = this.plugin.getCharacterManager().getHero(p);
        if (partialArgs.length != 1) {
            return null;
        }
        String partialIdent = "skill " + partialArgs[0];
        Collection<Skill> allSkills = this.plugin.getSkillManager().getSkills();
        ArrayList<String> results = new ArrayList<String>();
        for (Skill skill : allSkills) {
            if (!h.hasAccessToSkill(skill)) continue;
            for (String ident : skill.getIdentifiers()) {
                if (!ident.startsWith(partialIdent)) continue;
                results.add(ident.split(" ")[1]);
            }
        }
        return results;
    }

    private void displayCommandHelp(Command cmd, CommandSender sender) {
        sender.sendMessage("\u00a7cCommand:\u00a7e " + cmd.getName());
        if (sender instanceof Player && cmd instanceof Skill) {
            Hero hero = this.plugin.getCharacterManager().getHero((Player)sender);
            Skill cmdAsSkill = (Skill)cmd;
            sender.sendMessage("\u00a7cDescription:\u00a7e " + cmdAsSkill.getDescription(hero) + cmdAsSkill.getDescriptionMetadata(hero));
        } else {
            sender.sendMessage("\u00a7cDescription:\u00a7e " + cmd.getDescription());
        }
        sender.sendMessage("\u00a7cUsage:\u00a7e " + cmd.getUsage());
        if (cmd.getNotes() != null) {
            for (String note : cmd.getNotes()) {
                sender.sendMessage("\u00a7e" + note);
            }
        }
    }

    public Command getCmdFromIdent(String ident, CommandSender executor) {
        Skill skill = this.plugin.getSkillManager().getSkillFromIdent(ident, executor);
        if (skill != null) {
            return skill;
        }
        if (this.identifiers.get(ident.toLowerCase()) == null) {
            for (Command cmd : this.commands.values()) {
                if (!cmd.isIdentifier(executor, ident)) continue;
                return cmd;
            }
        }
        return this.identifiers.get(ident.toLowerCase());
    }

    public Command getCommand(String name) {
        return this.commands.get(name.toLowerCase());
    }

    public List<Command> getCommands() {
        return new ArrayList<Command>(this.commands.values());
    }

    public void removeCommand(Command command) {
        this.commands.remove(command.getName().toLowerCase());
        for (String ident : command.getIdentifiers()) {
            this.identifiers.remove(ident.toLowerCase());
        }
    }

    public static boolean hasPermission(CommandSender sender, String permission) {
        if (!(sender instanceof Player) || permission == null || permission.isEmpty()) {
            return true;
        }
        Player player = (Player)sender;
        return player.isOp() || Heroes.perms.has(player, permission);
    }
}

