/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command;

import com.herocraftonline.heroes.command.Command;
import org.bukkit.command.CommandSender;

public abstract class BasicCommand
implements Command {
    private final String name;
    private String description = "";
    private String shortDescription = null;
    private String usage = "";
    private String permission = "";
    private String[] notes = new String[0];
    private String[] identifiers = new String[0];
    private int minArguments = 0;
    private int maxArguments = 0;
    private String cacheKey;

    public BasicCommand(String name) {
        this.name = name;
        this.cacheKey = "BasicCommand_" + name;
    }

    @Override
    public void cancelInteraction(CommandSender executor) {
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hasShortDescription() {
        return this.shortDescription != null && this.shortDescription.length() > 0;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String description) {
        this.shortDescription = description;
    }

    @Override
    public String[] getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(String ... identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public int getMaxArguments() {
        return this.maxArguments;
    }

    @Override
    public int getMinArguments() {
        return this.minArguments;
    }

    public void setArgumentRange(int min, int max) {
        this.minArguments = min;
        this.maxArguments = max;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getNotes() {
        return this.notes;
    }

    public void setNotes(String ... notes) {
        this.notes = notes;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Override
    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Override
    public boolean isIdentifier(CommandSender executor, String input) {
        for (String identifier : this.identifiers) {
            if (!input.equalsIgnoreCase(identifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInProgress(CommandSender executor) {
        return false;
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public boolean isShownOnHelpMenu() {
        return true;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }
}

