/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.chat;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.command.Command;
import com.herocraftonline.heroes.util.Util;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import to.hc.common.bukkit.chat.ChatUtil;
import to.hc.common.bukkit.util.NMSHacks;

public class ChatComponents {
    public static final String BUTTON_SELECT = ChatColor.WHITE + "[" + ChatColor.BLUE + "Select" + ChatColor.WHITE + "]";
    public static final String BUTTON_QUESTION = ChatColor.WHITE + "[" + ChatColor.BLUE + "?" + ChatColor.WHITE + "]";
    public static final String GENERIC_SKILL = ChatColor.GRAY + "[" + ChatColor.DARK_GREEN + "\u2b50" + ChatColor.GRAY + "] ";
    public static final String GENERIC_LEVEL_UP = ChatColor.GRAY + "[" + ChatColor.LIGHT_PURPLE + "Level-Up" + ChatColor.GRAY + "] ";
    public static final String CHANNEL_PARTY = ChatColor.GREEN + "[Party] ";
    private static Cache<Command, BaseComponent[]> commandComponentCache = null;

    public static void sendSkillMessage(Player player, String message) {
        player.sendMessage("    " + GENERIC_SKILL + message);
    }

    public static BaseComponent[] getCachedCommand(Command key, Callable<BaseComponent[]> value) {
        try {
            return commandComponentCache != null ? (BaseComponent[])commandComponentCache.get((Object)key, value) : value.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void invalidateCommandComponentCache() {
        if (commandComponentCache != null) {
            commandComponentCache.invalidateAll();
        }
    }

    static {
        try {
            Method build = CacheBuilder.class.getMethod("build", new Class[0]);
            commandComponentCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
        }
        catch (Exception e) {
            Heroes.log(Level.WARNING, "Command caching disabled");
        }
    }

    public static enum Pairs {
        ATTRIBUTE_ADJUST(new ComponentBuilder("To adjust your attribute allocation points, ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("click here").color(ChatUtil.toBungee(ChatColor.GOLD)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/attributes")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("/attributes").create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(".").color(ChatUtil.toBungee(ChatColor.GRAY)).create(), ChatColor.GRAY + "You can adjust your attribute allocation points with " + ChatColor.GOLD + "/attributes.");

        private final BaseComponent[] components;
        private final String fallback;

        private Pairs(BaseComponent[] components, String fallback) {
            this.components = components;
            this.fallback = fallback;
        }

        public void send(CommandSender viewer) {
            NMSHacks.sendMessage(viewer, this.components, this.fallback);
        }
    }

    public static class Bars {
        public static String experience(int exp, int current, int next) {
            int i;
            int progress = (int)((double)(exp - current) / (double)(next - current) * 50.0);
            StringBuilder result = new StringBuilder(ChatColor.RED + "[" + ChatColor.DARK_GREEN);
            for (i = 0; i < progress; ++i) {
                result.append('|');
            }
            result.append(ChatColor.DARK_RED);
            for (i = 0; i < 50 - progress; ++i) {
                result.append('|');
            }
            result.append(ChatColor.RED).append("]");
            result.append(" - ").append(ChatColor.DARK_GREEN).append(progress * 2).append("%  ");
            result.append(ChatColor.DARK_GREEN).append(exp - current).append(ChatColor.RED).append("/").append(ChatColor.DARK_GREEN).append(next - current);
            return result.toString();
        }

        public static String health(double current, double max, boolean includePrefix) {
            int i;
            int percent = (int)(current / max * 100.0);
            int progress = percent / 2;
            StringBuilder result = new StringBuilder(ChatColor.GREEN + percent + "% ");
            result.append(ChatColor.RED).append("[").append(ChatColor.GREEN);
            for (i = 0; i < progress; ++i) {
                result.append('|');
            }
            result.append(ChatColor.DARK_RED);
            for (i = 0; i < 50 - progress; ++i) {
                result.append('|');
            }
            result.append(ChatColor.RED).append(']');
            if (includePrefix) {
                return ChatColor.GREEN + "HP: " + ChatColor.WHITE + Util.decFormat.format(Math.ceil(current)) + "/" + Util.decFormat.format(Math.ceil(max)) + " - " + result.toString();
            }
            return result.toString();
        }

        public static String shield(float current, int max, boolean includePrefix) {
            int i;
            int percent = (int)((double)(current / (float)max) * 100.0);
            int progress = percent / 2;
            StringBuilder result = new StringBuilder(ChatColor.GREEN + percent + "% ");
            result.append(ChatColor.RED).append("[").append(ChatColor.GREEN);
            for (i = 0; i < progress; ++i) {
                result.append('|');
            }
            result.append(ChatColor.DARK_RED);
            for (i = 0; i < 50 - progress; ++i) {
                result.append('|');
            }
            result.append(ChatColor.RED).append(']');
            if (includePrefix) {
                return ChatColor.GREEN + "Shield: " + ChatColor.WHITE + Util.decFormat.format(Math.ceil(current)) + "/" + Util.decFormat.format(Math.ceil(max)) + " - " + result.toString();
            }
            return result.toString();
        }

        public static String mana(int current, int max, boolean includePrefix) {
            int i;
            int percent = (int)((double)current / (double)max * 100.0);
            int progress = percent / 2;
            StringBuilder result = new StringBuilder(ChatColor.BLUE + percent + "% ");
            result.append(ChatColor.RED).append("[").append(ChatColor.BLUE);
            for (i = 0; i < progress; ++i) {
                result.append('|');
            }
            result.append(ChatColor.DARK_RED);
            for (i = 0; i < 50 - progress; ++i) {
                result.append('|');
            }
            result.append(ChatColor.RED).append(']');
            if (includePrefix) {
                return ChatColor.BLUE + "Mana: " + ChatColor.WHITE + current + "/" + max + " - " + result.toString();
            }
            return result.toString();
        }

        public static String stamina(int current, int max, boolean includePrefix) {
            int i;
            int percent = (int)((double)current / (double)max * 100.0);
            int progress = percent / 2;
            StringBuilder result = new StringBuilder(ChatColor.YELLOW + percent + "% ");
            result.append(ChatColor.RED).append("[").append(ChatColor.YELLOW);
            for (i = 0; i < progress; ++i) {
                result.append('|');
            }
            result.append(ChatColor.DARK_RED);
            for (i = 0; i < 50 - progress; ++i) {
                result.append('|');
            }
            result.append(ChatColor.RED).append(']');
            if (includePrefix) {
                return ChatColor.YELLOW + "Stamina: " + ChatColor.WHITE + current + "/" + max + " - " + result.toString();
            }
            return result.toString();
        }

        public static String skillProgress3(int current, int total) {
            boolean spaceForCurrent;
            int bars = 0;
            int percent = (int)((double)current / (double)total * 100.0);
            int progress = percent / 2;
            StringBuilder result = new StringBuilder();
            result.append(ChatColor.DARK_GRAY).append("[").append(ChatColor.GREEN);
            for (int i = 0; i < progress; ++i) {
                result.append('|');
                ++bars;
            }
            boolean bl = spaceForCurrent = bars != total && bars != total - 1;
            if (spaceForCurrent) {
                result.append(ChatColor.YELLOW).append('|');
            }
            result.append(ChatColor.RED);
            for (int i = 0; i < (spaceForCurrent ? 49 : 50) - progress; ++i) {
                result.append('|');
            }
            result.append(ChatColor.DARK_GRAY).append("] (");
            result.append(percent <= 49 ? ChatColor.RED : (percent == 50 ? ChatColor.YELLOW : ChatColor.GREEN)).append(percent).append("%").append(ChatColor.DARK_GRAY).append(")");
            return result.toString();
        }
    }

    public static enum ConfirmOrCancel {
        GENERIC(new ComponentBuilder("Please ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Confirm").color(ChatUtil.toBungee(ChatColor.GREEN)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/hero confirm")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("/hero confirm").create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(" or ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Cancel").color(ChatUtil.toBungee(ChatColor.RED)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/hero cancel")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("/hero cancel").create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(" your action.").color(ChatUtil.toBungee(ChatColor.GRAY)).create(), ChatColor.GRAY + "Please " + ChatColor.GREEN + "/hero confirm" + ChatColor.GRAY + " or " + ChatColor.RED + "/hero cancel" + ChatColor.GRAY + " your action."),
        ATTRIBUTE_ADD(new ComponentBuilder("Please ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Confirm").color(ChatUtil.toBungee(ChatColor.GREEN)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/attribute add confirm")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("/attribute add confirm").create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(" or ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Cancel").color(ChatUtil.toBungee(ChatColor.RED)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/attribute add cancel")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("/attribute add cancel").create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(" your action.").color(ChatUtil.toBungee(ChatColor.GRAY)).create(), ChatColor.GRAY + "Please " + ChatColor.GREEN + "/attribute add confirm" + ChatColor.GRAY + " or " + ChatColor.RED + "/attribute add cancel" + ChatColor.GRAY + " your action."),
        ATTRIBUTE_RESET(new ComponentBuilder("Please ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Confirm").color(ChatUtil.toBungee(ChatColor.GREEN)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/attribute reset confirm")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("/attribute reset confirm").create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(" or ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Cancel").color(ChatUtil.toBungee(ChatColor.RED)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/attribute reset cancel")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("/attribute reset cancel").create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(" your action.").color(ChatUtil.toBungee(ChatColor.GRAY)).create(), ChatColor.GRAY + "Please " + ChatColor.GREEN + "/attribute reset confirm" + ChatColor.GRAY + " or " + ChatColor.RED + "/attribute reset cancel" + ChatColor.GRAY + " your action.");

        public final BaseComponent[] components;
        public final String fallback;

        private ConfirmOrCancel(BaseComponent[] components, String fallback) {
            this.components = components;
            this.fallback = fallback;
        }

        public void send(CommandSender viewer) {
            NMSHacks.sendMessage(viewer, this.components, this.fallback);
        }
    }
}

