/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.tools;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.physics.FluidCollision;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.physics.RayCastFlag;
import com.herocraftonline.heroes.nms.physics.RayCastHit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Missile {
    private static NMSPhysics physics = NMSHandler.getInterface().getNMSPhysics();
    private static final double DELTA_TIME = 0.05;
    private static final double EPSILON = 1.0E-6;
    public static final double MIN_SPEED = 0.0;
    public static final double MIN_ENTITY_DETECT_RADIUS = 0.05;
    public static final double MAX_ENTITY_DETECT_RADIUS = 2.0;
    public static final double DEFAULT_ENTITY_DETECT_RADIUS = 0.2;
    public static final double MIN_MASS = 1.0E-6;
    public static final double DEFAULT_MASS = 1.0;
    public static final double MIN_DRAG = 0.0;
    public static final double DEFAULT_DRAG = 0.0;
    public static final double MIN_GRAVITY = -20.0;
    public static final double MAX_GRAVITY = 20.0;
    public static final double STANDARD_GRAVITY = 9.803;
    public static final double NO_GRAVITY = 0.0;
    public static final double DEFAULT_GRAVITY = 0.0;
    public static final long DEFAULT_DEATH_TICK = Long.MAX_VALUE;
    public static final boolean DEFAULT_COLLIDE_WITH_BLOCK_RESULT = true;
    public static final boolean DEFAULT_BLOCK_PROTECTS_ENTITY_RESULT = true;
    private World world = null;
    private Vector lastPosition = new Vector();
    private Vector position = new Vector();
    private Vector velocity = new Vector();
    private double entityDetectRadius = 0.2;
    private double mass = 1.0;
    private double drag = 0.0;
    private double gravity = 0.0;
    private Vector addedForces = new Vector();
    private Vector addedForcesIgnoringMass = new Vector();
    private long ticksLived = 0L;
    private long deathTick = Long.MAX_VALUE;
    private boolean isFinalTick = false;
    private FluidCollision blockFluicCollision = FluidCollision.ALWAYS;
    private boolean blockIgnoreNonCollidable;
    private Map<UUID, Long> entityIgnoreTicks = new HashMap<UUID, Long>();
    private MissileRunnable missileRunnable = new MissileRunnable();

    public final World getWorld() {
        return this.world;
    }

    public final Missile setWorld(World world) {
        this.world = Objects.requireNonNull(world, "world is null");
        return this;
    }

    public final Vector getPosition() {
        return this.position.clone();
    }

    public final void getPosition(Vector position) {
        position.copy(this.position);
    }

    public final Missile setPosition(Vector position) {
        this.position.copy(Objects.requireNonNull(position, "position is null"));
        return this;
    }

    protected final Vector getLastPosition() {
        return this.lastPosition.clone();
    }

    protected final void getLastPosition(Vector lastPosition) {
        Objects.requireNonNull(lastPosition, "lastPosition is null").copy(this.lastPosition);
    }

    public final Vector getVelocity() {
        return this.velocity;
    }

    public final Missile setVelocity(Vector velocity) {
        this.velocity.copy(Objects.requireNonNull(velocity));
        return this;
    }

    public final Vector getDirection() {
        return this.velocity.clone().normalize();
    }

    public final Missile setDirectionAndSpeed(Vector direction, double speed) {
        this.velocity.copy(direction.clone().normalize().multiply(speed));
        return this;
    }

    public final Missile setDirection(Vector direction) {
        return this.setDirectionAndSpeed(direction, this.getSpeed());
    }

    public final Location getLocation() {
        return this.position.toLocation(this.world).setDirection(this.velocity);
    }

    public final Missile setLocationAndSpeed(Location location, double speed) {
        Objects.requireNonNull(location, "location is null");
        this.setWorld(location.getWorld());
        this.setPosition(location.toVector());
        this.setDirectionAndSpeed(location.getDirection(), speed);
        return this;
    }

    public final Missile setLocation(Location location) {
        return this.setLocationAndSpeed(location, this.getSpeed());
    }

    public final double getSpeedSquared() {
        return this.velocity.lengthSquared();
    }

    public final double getSpeed() {
        return this.velocity.length();
    }

    public final Missile setSpeed(double speed) {
        speed = speed < 0.0 ? 0.0 : speed;
        this.velocity.normalize().multiply(speed);
        return this;
    }

    public final double getEntityDetectRadius() {
        return this.entityDetectRadius;
    }

    public final Missile setEntityDetectRadius(double entityDetectRadius) {
        this.entityDetectRadius = entityDetectRadius > 2.0 ? 2.0 : (entityDetectRadius < 0.05 ? 0.05 : entityDetectRadius);
        return this;
    }

    public final double getMass() {
        return this.mass;
    }

    public final Missile setMass(double mass) {
        this.mass = mass < 1.0E-6 ? 1.0E-6 : mass;
        return this;
    }

    public final double getDrag() {
        return this.drag;
    }

    public final Missile setDrag(double drag) {
        this.drag = drag < 0.0 ? 0.0 : drag;
        return this;
    }

    public final boolean hasAppliedGravity() {
        return this.gravity > 1.0E-6;
    }

    public final double getGravity() {
        return this.gravity;
    }

    public final Missile setGravity(double gravity) {
        this.gravity = gravity < -20.0 ? -20.0 : (gravity > 20.0 ? 20.0 : gravity);
        return this;
    }

    public final Missile setNoGravity() {
        this.gravity = 0.0;
        return this;
    }

    public final Missile setStandardGravity() {
        this.gravity = 9.803;
        return this;
    }

    public final void setFluidCollision(FluidCollision collision) {
        this.blockFluicCollision = collision;
    }

    public final FluidCollision getFluidCollision() {
        return this.blockFluicCollision;
    }

    public final void setBlockIgnoreNonCollidable(boolean blockIgnoreNonCollidable) {
        this.blockIgnoreNonCollidable = blockIgnoreNonCollidable;
    }

    public final boolean getBlockIgnoreNonCollidable() {
        return this.blockIgnoreNonCollidable;
    }

    public final Missile addForce(Vector force, boolean ignoreMass) {
        Objects.requireNonNull(force, "force is null");
        if (ignoreMass) {
            this.addedForces.add(force);
        } else {
            this.addedForcesIgnoringMass.add(force);
        }
        return this;
    }

    public final Missile applyImpulse(Vector impulse, boolean ignoreMass) {
        Objects.requireNonNull(impulse, "impulse is null");
        if (ignoreMass) {
            this.velocity.add(impulse);
        } else {
            this.velocity.add(impulse.clone().multiply(1.0 / this.mass));
        }
        return this;
    }

    public final Missile addForce(Vector force) {
        return this.addForce(force, false);
    }

    public final long getTicksLived() {
        return this.ticksLived;
    }

    public final long getDeathTick() {
        return this.deathTick;
    }

    public final Missile setDeathTick(long deathTick) {
        if (!this.isFinalTick) {
            this.deathTick = deathTick;
        }
        return this;
    }

    public final long getRemainingLife() {
        return this.deathTick - this.ticksLived;
    }

    public final Missile setRemainingLife(long ticks) {
        return this.setDeathTick(this.ticksLived + ticks);
    }

    public final boolean isFinalTick() {
        return this.isFinalTick;
    }

    @Deprecated
    public final EnumSet<RayCastFlag> getRayCastFlags() {
        return EnumSet.noneOf(RayCastFlag.class);
    }

    public final long getEntityIgnoreTicks(UUID entityId) {
        Objects.requireNonNull(entityId, "entityId is null");
        return this.entityIgnoreTicks.getOrDefault(entityId, 0L);
    }

    public final long getEntityIgnoreTicks(Entity entity) {
        return this.getEntityIgnoreTicks(Objects.requireNonNull(entity, "entity is null").getUniqueId());
    }

    public final Missile setEntityIgnoreTicks(UUID entityId, long ignoreTicks) {
        Objects.requireNonNull(entityId, "entityId is null");
        if (ignoreTicks > 0L) {
            this.entityIgnoreTicks.put(entityId, ignoreTicks);
        } else {
            this.entityIgnoreTicks.remove(entityId);
        }
        return this;
    }

    public final Missile setEntityIgnoreTicks(Entity entity, long ignoreTicks) {
        return this.setEntityIgnoreTicks(Objects.requireNonNull(entity, "entity is null").getUniqueId(), ignoreTicks);
    }

    public final boolean isActive() {
        return this.missileRunnable != null;
    }

    public final void fireMissile() {
        if (this.world == null) {
            throw new IllegalStateException("Missile must have a world to exist in");
        }
        if (this.isActive()) {
            this.missileRunnable.fireMissile();
        }
    }

    public final boolean isFired() {
        return this.isActive() && this.missileRunnable.isFired();
    }

    public final void kill() {
        this.deathTick = this.ticksLived;
        this.isFinalTick = true;
    }

    protected void onAwake() {
    }

    protected void onStart() {
    }

    protected void onTick() {
    }

    protected void onFinalTick() {
    }

    protected boolean onCollideWithBlock(Block block, Vector point, BlockFace face) {
        return true;
    }

    protected boolean onBlockProtectsEntity(Block block, Entity entity, Vector point, BlockFace face) {
        return true;
    }

    protected boolean onCollideWithEntity(Entity entity) {
        return !(entity instanceof ArmorStand);
    }

    protected void onEntityHit(Entity entity, Vector hitOrigin, Vector hitForce) {
    }

    protected void onEntityPassed(Entity entity, Vector passOrigin, Vector passForce) {
    }

    protected void onBlockHit(Block block, Vector hitPoint, BlockFace hitFace, Vector hitForce) {
    }

    protected void onBlockPassed(Block block, Vector passPoint, BlockFace passFace, Vector passForce) {
    }

    private final class MissileRunnable
    extends BukkitRunnable {
        private boolean isFired = false;

        private MissileRunnable() {
        }

        public boolean isFired() {
            return this.isFired;
        }

        public void fireMissile() {
            if (!this.isFired) {
                this.runTaskTimer((Plugin)Heroes.getInstance(), 1L, 1L);
                this.isFired = true;
                try {
                    Missile.this.onAwake();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void run() {
            if (Missile.this.ticksLived == 0L) {
                try {
                    Missile.this.onStart();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++Missile.this.ticksLived;
            if (Missile.this.hasAppliedGravity()) {
                Missile.this.addedForces.add(new Vector(0.0, -Missile.this.gravity, 0.0));
            }
            if (Missile.this.drag > 0.0) {
                Vector dragForce = new Vector().copy(Missile.this.velocity).normalize().multiply(-0.5 * Missile.this.drag * Missile.this.velocity.lengthSquared());
                Missile.this.addedForces.add(dragForce);
            }
            Missile.this.velocity.add(Missile.this.addedForces.multiply(1.0 / Missile.this.mass).add(Missile.this.addedForcesIgnoringMass).multiply(0.05));
            Missile.this.lastPosition.copy(Missile.this.position);
            Missile.this.position.add(Missile.this.velocity.clone().multiply(0.05));
            Vector missileRay = Missile.this.position.clone().subtract(Missile.this.lastPosition);
            double missileRayLengthSq = missileRay.lengthSquared();
            BlockCollision hitBlock = null;
            ArrayList<BlockCollision> passedBlocks = new ArrayList<BlockCollision>();
            Iterator<RayCastHit> rayCastHitBlocks = physics.rayCastBlocksAll(Missile.this.world, Missile.this.lastPosition, Missile.this.position, Missile.this.blockFluicCollision, Missile.this.blockIgnoreNonCollidable);
            while (hitBlock == null && rayCastHitBlocks.hasNext()) {
                RayCastHit rayCastHitBlock = rayCastHitBlocks.next();
                Block block = rayCastHitBlock.getBlock(Missile.this.world);
                Vector hitPoint = rayCastHitBlock.getPoint();
                BlockFace hitFace = rayCastHitBlock.getFace();
                boolean collideWithBlock = true;
                try {
                    collideWithBlock = Missile.this.onCollideWithBlock(block, hitPoint, hitFace);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                double hitDistanceSq = hitPoint.clone().subtract(Missile.this.lastPosition).lengthSquared();
                BlockCollision blockCollision = new BlockCollision(block, hitPoint, hitFace, hitDistanceSq);
                if (collideWithBlock) {
                    Missile.this.position.copy(hitPoint);
                    hitBlock = blockCollision;
                    continue;
                }
                passedBlocks.add(blockCollision);
            }
            EntityCollision hitEntity = null;
            ArrayList<EntityCollision> passedEntities = new ArrayList<EntityCollision>();
            List<Entity> entitiesInPath = physics.getEntitiesInVolume(Missile.this.world, null, physics.createCapsule(Missile.this.lastPosition, Missile.this.position, Missile.this.entityDetectRadius));
            for (Entity entity : entitiesInPath) {
                long ignoreTicks = Missile.this.entityIgnoreTicks.getOrDefault(entity.getUniqueId(), 0L);
                if (ignoreTicks > 0L) {
                    Missile.this.entityIgnoreTicks.put(entity.getUniqueId(), --ignoreTicks);
                    continue;
                }
                Missile.this.entityIgnoreTicks.remove(entity.getUniqueId());
                Vector entityCenter = physics.getEntityAABB(entity).getCenter();
                double dot = missileRay.dot(entityCenter.clone().subtract(Missile.this.lastPosition));
                if (dot < 0.0) continue;
                Vector missileHit = dot == 0.0 ? Missile.this.lastPosition.clone() : (dot >= missileRayLengthSq ? Missile.this.position.clone() : Missile.this.lastPosition.clone().add(missileRay.clone().multiply(dot / missileRayLengthSq)));
                Iterator<RayCastHit> rayCastHitBlocks2 = physics.rayCastBlocksAll(Missile.this.world, missileHit, entityCenter);
                boolean entityHit = true;
                while (entityHit && rayCastHitBlocks2.hasNext()) {
                    RayCastHit rayCastHitBlock = rayCastHitBlocks2.next();
                    Block block = rayCastHitBlock.getBlock(Missile.this.world);
                    Vector hitPoint = rayCastHitBlock.getPoint();
                    BlockFace hitFace = rayCastHitBlock.getFace();
                    boolean blockProtectsEntity = true;
                    try {
                        blockProtectsEntity = Missile.this.onBlockProtectsEntity(block, entity, hitPoint, hitFace);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (!blockProtectsEntity) continue;
                    entityHit = false;
                }
                if (!entityHit) continue;
                double hitDistanceSq = missileRay.clone().multiply(dot / missileRayLengthSq).lengthSquared();
                boolean collideWithEntity = false;
                try {
                    collideWithEntity = Missile.this.onCollideWithEntity(entity);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (collideWithEntity) {
                    if (hitEntity != null && !(hitDistanceSq < hitEntity.hitDistanceSq)) continue;
                    hitEntity = new EntityCollision(entity, entityCenter, missileHit, hitDistanceSq);
                    continue;
                }
                passedEntities.add(new EntityCollision(entity, entityCenter, missileHit, hitDistanceSq));
            }
            double appliedHitDistanceSq = 9.223372036854776E18;
            if (hitEntity != null) {
                appliedHitDistanceSq = Math.min(appliedHitDistanceSq, hitEntity.hitDistanceSq);
                Missile.this.position.copy(hitEntity.hitOrigin);
                try {
                    Missile.this.onEntityHit(hitEntity.entity, hitEntity.hitOrigin, Missile.this.velocity.clone());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Missile.this.kill();
            } else if (hitBlock != null) {
                appliedHitDistanceSq = Math.min(appliedHitDistanceSq, hitBlock.hitDistanceSq);
                try {
                    Missile.this.onBlockHit(hitBlock.block, hitBlock.hitPoint, hitBlock.hitFace, Missile.this.velocity.clone());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Missile.this.kill();
            }
            for (BlockCollision blockCollision : passedBlocks) {
                if (hitBlock != null && !(blockCollision.hitDistanceSq < appliedHitDistanceSq)) continue;
                try {
                    Missile.this.onBlockPassed(blockCollision.block, blockCollision.hitPoint, blockCollision.hitFace, Missile.this.velocity.clone());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            for (EntityCollision entityCollision : passedEntities) {
                if (hitEntity != null && !(entityCollision.hitDistanceSq < appliedHitDistanceSq)) continue;
                try {
                    Missile.this.onEntityPassed(entityCollision.entity, entityCollision.hitOrigin, Missile.this.velocity.clone());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                Missile.this.onTick();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (Missile.this.isFinalTick || Missile.this.ticksLived >= Missile.this.deathTick) {
                this.cancel();
                Missile.this.missileRunnable = null;
                try {
                    Missile.this.onFinalTick();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static class EntityCollision {
        public final Entity entity;
        public final Vector entityCenter;
        public final Vector hitOrigin;
        public final double hitDistanceSq;

        public EntityCollision(Entity entity, Vector entityCenter, Vector hitOrigin, double hitDistanceSq) {
            this.entity = entity;
            this.entityCenter = entityCenter;
            this.hitDistanceSq = hitDistanceSq;
            this.hitOrigin = hitOrigin;
        }
    }

    private static class BlockCollision {
        public final Block block;
        public final Vector hitPoint;
        public final BlockFace hitFace;
        public final double hitDistanceSq;

        public BlockCollision(Block block, Vector hitPoint, BlockFace hitFace, double hitDistanceSq) {
            this.block = block;
            this.hitPoint = hitPoint;
            this.hitFace = hitFace;
            this.hitDistanceSq = hitDistanceSq;
        }
    }
}

