/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.tools;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.tools.Missile;
import de.slikey.effectlib.Effect;
import de.slikey.effectlib.EffectManager;
import de.slikey.effectlib.effect.SphereEffect;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class BasicMissile
extends Missile {
    public static final String PROJECTILE_DURATION_TICKS_NODE = "projectile-max-ticks-lived";
    public static final String PROJECTILE_GRAVITY_NODE = "projectile-gravity";
    public static final String PROJECTILE_SIZE_NODE = "projectile-size";
    public static final String PROJECTILE_PIERCES_ON_HIT_NODE = "projectile-pierces-on-hit";
    public static final String PROJECTILE_VELOCITY_NODE = "projectile-velocity";
    public static Particle DEFAULT_PARTICLE = Particle.REDSTONE;
    public static Color DEFAULT_COLOR = Color.fromRGB((int)0, (int)191, (int)255);
    protected final Heroes plugin;
    protected final Skill skill;
    protected final Hero hero;
    protected final Player player;
    protected final boolean isOffensive;
    protected EffectManager effectManager;
    public Effect visualEffect;
    protected final boolean shouldPierce;
    protected final List<LivingEntity> hitTargets = new ArrayList<LivingEntity>();

    public BasicMissile(Heroes plugin, Skill skill, Hero hero) {
        this(plugin, skill, hero, DEFAULT_PARTICLE, DEFAULT_COLOR, true);
    }

    public BasicMissile(Heroes plugin, Skill skill, Hero hero, boolean isOffensive) {
        this(plugin, skill, hero, DEFAULT_PARTICLE, DEFAULT_COLOR, isOffensive);
    }

    public BasicMissile(Heroes plugin, Skill skill, Hero hero, Particle particle) {
        this(plugin, skill, hero, particle, DEFAULT_COLOR, true);
    }

    public BasicMissile(Heroes plugin, Skill skill, Hero hero, Particle particle, boolean isOffensive) {
        this(plugin, skill, hero, particle, DEFAULT_COLOR, isOffensive);
    }

    public BasicMissile(Heroes plugin, Skill skill, Hero hero, Color color) {
        this(plugin, skill, hero, DEFAULT_PARTICLE, color, true);
    }

    public BasicMissile(Heroes plugin, Skill skill, Hero hero, Color color, boolean isOffensive) {
        this(plugin, skill, hero, DEFAULT_PARTICLE, color, isOffensive);
    }

    public BasicMissile(Heroes plugin, Skill skill, Hero hero, Particle particle, Color color, boolean isOffensive) {
        this.plugin = plugin;
        this.skill = skill;
        this.hero = hero;
        this.player = hero.getPlayer();
        this.isOffensive = isOffensive;
        this.setRemainingLife(SkillConfigManager.getUseSetting(hero, skill, PROJECTILE_DURATION_TICKS_NODE, 20, false));
        this.setGravity(SkillConfigManager.getUseSetting(hero, skill, PROJECTILE_GRAVITY_NODE, 0.0, false));
        this.setEntityDetectRadius(SkillConfigManager.getUseSetting(hero, skill, PROJECTILE_SIZE_NODE, 0.35, false));
        double projectileSpeed = SkillConfigManager.getUseSetting(hero, skill, PROJECTILE_VELOCITY_NODE, 20.0, false);
        this.shouldPierce = SkillConfigManager.getUseSetting(hero, skill, PROJECTILE_PIERCES_ON_HIT_NODE, false);
        this.setLocationAndSpeed(this.buildMissileStartLocation(), projectileSpeed);
        this.effectManager = new EffectManager((Plugin)plugin);
        SphereEffect vEffect = new SphereEffect(this.effectManager);
        vEffect.radius = this.getEntityDetectRadius();
        vEffect.particle = particle;
        vEffect.color = color;
        vEffect.period = 1;
        vEffect.iterations = 6000;
        this.visualEffect = vEffect;
    }

    protected Location buildMissileStartLocation() {
        return this.player.getEyeLocation();
    }

    protected void replaceEffects(EffectManager newManager, Effect newVEffect) {
        if (this.effectManager != null) {
            this.effectManager.dispose();
        }
        this.effectManager = newManager;
        this.visualEffect = newVEffect;
    }

    @Override
    protected void onStart() {
        if (this.visualEffect != null) {
            this.visualEffect.setLocation(this.getLocation());
            if (this.effectManager != null) {
                this.effectManager.start(this.visualEffect);
            }
        }
    }

    @Override
    protected void onTick() {
        if (this.visualEffect != null && this.getTicksLived() % 2L == 0L) {
            this.visualEffect.setLocation(this.getLocation());
        }
    }

    @Override
    protected void onFinalTick() {
        if (this.effectManager != null) {
            this.effectManager.dispose();
        }
    }

    @Override
    protected boolean onCollideWithEntity(Entity entity) {
        if (this.shouldPierce) {
            return false;
        }
        return !this.isInvalidTarget(entity);
    }

    @Override
    protected void onEntityPassed(Entity entity, Vector passOrigin, Vector passForce) {
        if (this.isInvalidTarget(entity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (this.isOffensive && !Skill.damageCheck(this.player, target)) {
            return;
        }
        this.onValidTargetFound(target, passOrigin, passForce);
        if (!this.shouldPierce) {
            this.kill();
        }
    }

    @Override
    protected void onEntityHit(Entity entity, Vector hitOrigin, Vector hitForce) {
        if (this.isInvalidTarget(entity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (this.isOffensive && !Skill.damageCheck(this.player, target)) {
            return;
        }
        this.onValidTargetFound(target, hitOrigin, hitForce);
    }

    protected boolean isInvalidTarget(Entity entity) {
        boolean isInvalid;
        boolean bl = isInvalid = !(entity instanceof LivingEntity) || entity.equals(this.player) || this.hitTargets.contains(entity);
        if (isInvalid) {
            return isInvalid;
        }
        boolean isAlliedTarget = this.hero.isAlliedTo((LivingEntity)entity);
        return this.isOffensive && isAlliedTarget || !this.isOffensive && !isAlliedTarget;
    }

    protected void onValidTargetFound(LivingEntity target, Vector origin, Vector passForce) {
    }
}

