/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.tools;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.tools.BasicMissile;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;

public class BasicHealMissile
extends BasicMissile {
    public static Particle DEFAULT_PARTICLE = Particle.REDSTONE;
    public static Color DEFAULT_COLOR = Color.GREEN;
    public double healing;

    public BasicHealMissile(Heroes plugin, Skill skill, Hero hero) {
        this(plugin, skill, hero, DEFAULT_PARTICLE, DEFAULT_COLOR);
    }

    public BasicHealMissile(Heroes plugin, Skill skill, Hero hero, Particle particle) {
        this(plugin, skill, hero, particle, DEFAULT_COLOR);
    }

    public BasicHealMissile(Heroes plugin, Skill skill, Hero hero, Color color) {
        this(plugin, skill, hero, DEFAULT_PARTICLE, color);
    }

    public BasicHealMissile(Heroes plugin, Skill skill, Hero hero, Particle particle, Color color) {
        super(plugin, skill, hero, particle, color, false);
        this.healing = SkillConfigManager.getScaledUseSettingDouble(hero, skill, SkillSetting.HEALING, false);
    }

    protected void onValidTargetFound(LivingEntity target) {
        this.hitTargets.add(target);
        CharacterTemplate targetCT = this.plugin.getCharacterManager().getCharacter(target);
        targetCT.tryHeal(this.hero, this.skill, this.healing);
    }
}

