/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.tools;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.tools.BasicMissile;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;

public class BasicDamageMissile
extends BasicMissile {
    public static final String PROJECTILE_KNOCKS_BACK_ON_HIT_NODE = "projectile-knocks-back-on-hit";
    public static final String PROJECTILE_CUSTOM_KNOCKBACK_FORCE_NODE = "projectile-custom-knockback-force";
    public static final String PROJECTILE_CUSTOM_KNOCKBACK_Y_MULTIPLIER_NODE = "projectile-custom-knockback-y-multiplier";
    public static Particle DEFAULT_PARTICLE = Particle.REDSTONE;
    public static Color DEFAULT_COLOR = Color.fromRGB((int)0, (int)191, (int)255);
    public static EntityDamageEvent.DamageCause DEFAULT_DAMAGE_CAUSE = EntityDamageEvent.DamageCause.MAGIC;
    public double damage;
    protected EntityDamageEvent.DamageCause damageCause;
    protected final boolean knockBackOnHit;
    protected double customKnockbackPower = 0.0;
    protected double customKnockbackYPower = 0.0;

    public BasicDamageMissile(Heroes plugin, Skill skill, Hero hero) {
        this(plugin, skill, hero, DEFAULT_PARTICLE, DEFAULT_COLOR, DEFAULT_DAMAGE_CAUSE);
    }

    public BasicDamageMissile(Heroes plugin, Skill skill, Hero hero, Particle particle) {
        this(plugin, skill, hero, particle, DEFAULT_COLOR, DEFAULT_DAMAGE_CAUSE);
    }

    public BasicDamageMissile(Heroes plugin, Skill skill, Hero hero, Color color) {
        this(plugin, skill, hero, DEFAULT_PARTICLE, color, DEFAULT_DAMAGE_CAUSE);
    }

    public BasicDamageMissile(Heroes plugin, Skill skill, Hero hero, Particle particle, Color color, EntityDamageEvent.DamageCause damageCause) {
        super(plugin, skill, hero, particle, color, true);
        this.damageCause = damageCause;
        this.damage = SkillConfigManager.getScaledUseSettingDouble(hero, skill, SkillSetting.DAMAGE, false);
        this.knockBackOnHit = SkillConfigManager.getUseSetting(hero, skill, PROJECTILE_KNOCKS_BACK_ON_HIT_NODE, true);
        if (this.knockBackOnHit) {
            this.customKnockbackPower = SkillConfigManager.getUseSetting(hero, skill, PROJECTILE_CUSTOM_KNOCKBACK_FORCE_NODE, 0.75, false);
            this.customKnockbackYPower = SkillConfigManager.getUseSetting(hero, skill, PROJECTILE_CUSTOM_KNOCKBACK_Y_MULTIPLIER_NODE, 0.5, false);
        }
    }

    @Override
    protected void onValidTargetFound(LivingEntity target, Vector origin, Vector force) {
        this.hitTargets.add(target);
        this.skill.addSpellTarget((Entity)target, this.hero);
        boolean shouldUseVanillaKnockback = this.knockBackOnHit && this.customKnockbackPower <= 0.0;
        this.skill.damageEntity(target, (LivingEntity)this.player, this.damage, this.damageCause, shouldUseVanillaKnockback);
        if (this.knockBackOnHit && this.customKnockbackPower > 0.0) {
            target.setVelocity(force.normalize().multiply(new Vector(this.customKnockbackPower, this.customKnockbackPower * this.customKnockbackYPower, this.customKnockbackPower)));
        }
    }
}

