/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills.totem;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.skill.skills.totem.SkillBaseTotem;
import com.herocraftonline.heroes.characters.skill.skills.totem.Totem;
import com.herocraftonline.heroes.characters.skill.skills.totem.TotemEffect;
import java.util.Iterator;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.server.PluginDisableEvent;

public class TotemListener
implements Listener {
    private Heroes plugin;

    public TotemListener(Heroes plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginDisable(PluginDisableEvent e) {
        if (e.getPlugin() != this.plugin) {
            return;
        }
        Iterator<Totem> iter = SkillBaseTotem.totems.iterator();
        while (iter.hasNext()) {
            Totem totem = iter.next();
            totem.destroyTotem();
            totem.getEffect().expire();
            iter.remove();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent e) {
        Hero hero = this.plugin.getCharacterManager().getHero(e.getEntity());
        if (!hero.hasEffect("TotemEffect")) {
            return;
        }
        Effect effect = hero.getEffect("TotemEffect");
        if (effect instanceof TotemEffect) {
            ((TotemEffect)effect).expire();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent e) {
        if (SkillBaseTotem.isTotemBlock(e.getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof EnderCrystal && SkillBaseTotem.isTotemCrystal((EnderCrystal)e.getEntity())) {
            e.setCancelled(true);
        }
        if (e.getEntity() instanceof LivingEntity && e.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION && SkillBaseTotem.isTotemBlock(((LivingEntity)e.getEntity()).getEyeLocation().getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityExplode(EntityExplodeEvent e) {
        if (!(e.getEntity() instanceof EnderCrystal)) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent e) {
        if (!(e.getDamager() instanceof EnderCrystal)) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPistonExtend(BlockPistonExtendEvent e) {
        for (Block block : e.getBlocks()) {
            if (!SkillBaseTotem.isTotemBlock(block)) continue;
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPistonRetract(BlockPistonRetractEvent e) {
        for (Block block : e.getBlocks()) {
            if (!SkillBaseTotem.isTotemBlock(block)) continue;
            e.setCancelled(true);
            return;
        }
    }
}

