/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills.totem;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.skills.totem.SkillBaseTotem;
import com.herocraftonline.heroes.characters.skill.skills.totem.Totem;
import org.bukkit.entity.Player;

public class TotemEffect
extends PeriodicExpirableEffect {
    private SkillBaseTotem totemSkill;
    private Totem totem;
    private boolean forcedExpire;

    public TotemEffect(SkillBaseTotem skill, Totem totem, Player applier, long period, long duration) {
        this(skill, "TotemEffect", totem, applier, period, duration);
    }

    public TotemEffect(SkillBaseTotem skill, String name, Totem totem, Player applier, long period, long duration) {
        super((Skill)skill, name, applier, period, duration);
        this.totemSkill = skill;
        this.totem = totem;
    }

    @Override
    public void tickHero(Hero hero) {
        this.totemSkill.usePower(hero, this.totem);
    }

    @Override
    public void applyToHero(Hero hero) {
        this.totem.setEffect(this);
        this.totem.createTotem(this.totemSkill.getMaterial());
        SkillBaseTotem.totems.add(this.totem);
        super.applyToHero(hero);
    }

    @Override
    public void removeFromHero(Hero hero) {
        if (!this.forcedExpire && this.totem.getFireOnNaturalRemove()) {
            this.totemSkill.usePower(hero, this.totem);
        }
        this.totemSkill.totemDestroyed(hero, this.totem);
        this.totem.destroyTotem();
        SkillBaseTotem.totems.remove(this.totem);
        super.removeFromHero(hero);
    }

    @Override
    public void expire() {
        this.forcedExpire = true;
        super.expire();
    }

    public Totem getTotem() {
        return this.totem;
    }

    public SkillBaseTotem getTotemSkill() {
        return this.totemSkill;
    }

    @Override
    public void tickMonster(Monster monster) {
    }
}

