/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills.totem;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.skills.totem.SkillBaseTotem;
import com.herocraftonline.heroes.characters.skill.skills.totem.TotemEffect;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class Totem {
    private Location loc;
    private boolean fireOnNaturalRemove;
    private double range;
    private List<Block> blocks = new ArrayList<Block>();
    private EnderCrystal crystal;
    private TotemEffect effect = null;

    public Totem(SkillBaseTotem skill, Location loc, boolean fireOnNaturalRemove, double range) {
        this.setLocation(loc);
        this.setRange(range);
        this.setFireOnNaturalRemove(fireOnNaturalRemove);
    }

    public boolean canCreateTotem(Material material) {
        boolean isGrounded = false;
        World world = this.loc.getWorld();
        this.blocks.add(world.getBlockAt(this.loc));
        this.blocks.add(world.getBlockAt(this.loc).getRelative(BlockFace.UP));
        this.blocks.add(world.getBlockAt(this.loc).getRelative(BlockFace.UP, 2));
        for (int i = 0; i < 3; ++i) {
            Block block = this.blocks.get(i);
            if (!block.getType().equals((Object)Material.AIR)) {
                return false;
            }
            if (i >= 2) continue;
            if (!block.getRelative(BlockFace.DOWN).getType().equals((Object)Material.AIR)) {
                isGrounded = true;
            }
            if (!SkillBaseTotem.totemExistsInRadius(this.blocks.get(0), 5)) continue;
            return false;
        }
        return isGrounded;
    }

    public void createTotem(Material material) {
        World world = this.loc.getWorld();
        for (int i = 0; i < 2; ++i) {
            this.blocks.get(i).setType(material);
        }
        this.crystal = (EnderCrystal)world.spawnEntity(this.blocks.get(1).getLocation().add(0.5, 0.75, 0.5), EntityType.ENDER_CRYSTAL);
    }

    public void destroyTotem() {
        for (int i = 0; i < 2; ++i) {
            Block block = this.blocks.get(i);
            Chunk chunk = block.getChunk();
            if (!chunk.isLoaded()) {
                chunk.load();
            }
            block.setType(Material.AIR);
        }
        this.crystal.remove();
    }

    public Location getLocation() {
        return this.loc;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }

    public double getRange() {
        return this.range;
    }

    public void setRange(double range) {
        this.range = range;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<Block> blocks) {
        this.blocks = blocks;
    }

    public Block getBlock(int id) {
        return this.blocks.get(id);
    }

    public void setBlock(int id, Block block) {
        this.blocks.set(id, block);
    }

    public List<LivingEntity> getTargets(Hero hero) {
        double range = this.getRange();
        List potentialTargets = this.crystal.getNearbyEntities(range, range, range);
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        for (Entity target : potentialTargets) {
            if (!(target instanceof LivingEntity)) continue;
            targets.add((LivingEntity)target);
        }
        return targets;
    }

    public EnderCrystal getCrystal() {
        return this.crystal;
    }

    public void setCrystal(EnderCrystal crystal) {
        this.crystal = crystal;
    }

    public boolean getFireOnNaturalRemove() {
        return this.fireOnNaturalRemove;
    }

    public void setFireOnNaturalRemove(boolean fireOnNaturalRemove) {
        this.fireOnNaturalRemove = fireOnNaturalRemove;
    }

    public TotemEffect getEffect() {
        return this.effect;
    }

    public void setEffect(TotemEffect effect) {
        this.effect = effect;
    }
}

