/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills.totem;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.skills.totem.Totem;
import com.herocraftonline.heroes.characters.skill.skills.totem.TotemEffect;
import com.herocraftonline.heroes.characters.skill.skills.totem.TotemListener;
import com.herocraftonline.heroes.chat.ChatComponents;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class SkillBaseTotem
extends ActiveSkill {
    public Material material = Material.BEDROCK;
    public static ArrayList<Totem> totems = new ArrayList();

    public SkillBaseTotem(Heroes plugin, String name) {
        super(plugin, name);
    }

    public static boolean isTotemBlock(Block block) {
        for (Totem totem : totems) {
            if (!totem.getBlocks().contains(block)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTotemCrystal(EnderCrystal crystal) {
        for (Totem totem : totems) {
            if (totem.getCrystal() != crystal) continue;
            return true;
        }
        return false;
    }

    public static boolean totemExistsInRadius(Block center, int radius) {
        Vector min = center.getLocation().subtract((double)radius, (double)radius, (double)radius).toVector();
        Vector max = center.getLocation().add((double)radius, (double)radius, (double)radius).toVector();
        for (Totem totem : totems) {
            if (!totem.getBlock(0).getLocation().toVector().isInAABB(min, max)) continue;
            return true;
        }
        return false;
    }

    public abstract void usePower(Hero var1, Totem var2);

    public void totemDestroyed(Hero hero, Totem totem) {
    }

    @Override
    public SkillResult use(Hero hero, String[] args) {
        Location loc = hero.getPlayer().getTargetBlock((Set)null, 20).getLocation().add(0.0, 1.0, 0.0);
        Totem totem = new Totem(this, loc, this.getFireOnNaturalRemove(hero), this.getRange(hero));
        if (hero.hasEffect("TotemEffect")) {
            hero.getPlayer().sendMessage(ChatColor.RED + "You already have an active totem!");
            return SkillResult.CANCELLED;
        }
        if (!totem.canCreateTotem(this.material)) {
            hero.getPlayer().sendMessage(ChatColor.RED + "Invalid totem location!");
            return SkillResult.CANCELLED;
        }
        hero.addEffect(new TotemEffect(this, totem, hero.getPlayer(), this.getPeriod(hero), this.getDuration(hero)));
        this.broadcastExecuteText(hero);
        return SkillResult.NORMAL;
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection node = super.getDefaultConfig();
        node.set(SkillSetting.DURATION.node(), (Object)60000);
        node.set(SkillSetting.DURATION_INCREASE_PER_WISDOM.node(), (Object)100);
        node.set("duration-per-level", (Object)100);
        node.set("range", (Object)5);
        node.set("range-per-level", (Object)0.1);
        node.set(SkillSetting.PERIOD.node(), (Object)1000L);
        node.set("fireOnNaturalRemove", (Object)true);
        node.set(SkillSetting.USE_TEXT.node(), (Object)(ChatComponents.GENERIC_SKILL + "%hero% placed a(n) " + this.getName().replace("Totem", "") + " totem!"));
        return this.getSpecificDefaultConfig(node);
    }

    public long getDuration(Hero hero) {
        return SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.DURATION, 60000, false) + SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.DURATION_INCREASE_PER_WISDOM, 100, false) * hero.getAttributeValue(AttributeType.WISDOM) + SkillConfigManager.getUseSetting(hero, (Skill)this, "duration-per-level", 100, false) * hero.getHeroLevel(this);
    }

    public double getRange(Hero hero) {
        return (double)SkillConfigManager.getUseSetting(hero, (Skill)this, "range", 5, false) + SkillConfigManager.getUseSetting(hero, (Skill)this, "range-per-level", 0.1, false) * (double)hero.getHeroLevel(this);
    }

    public long getPeriod(Hero hero) {
        return SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.PERIOD, 1000, false);
    }

    public boolean getFireOnNaturalRemove(Hero hero) {
        return SkillConfigManager.getUseSetting(hero, (Skill)this, "fireOnNaturalRemove", true);
    }

    public Material getMaterial() {
        return this.material;
    }

    public ConfigurationSection getSpecificDefaultConfig(ConfigurationSection node) {
        return node;
    }

    static {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new TotemListener(Heroes.getInstance()), (Plugin)Heroes.getInstance());
    }
}

