/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.api.events.AfterClassChangeEvent;
import com.herocraftonline.heroes.api.events.HeroChangeLevelEvent;
import com.herocraftonline.heroes.api.events.WeaponDamageEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.RecastData;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public abstract class SkillBaseWeaponImbue
extends ActiveSkill {
    private static final String WEAPON_IMBUE_EFFECT_NAME = "Weapon Imbue";
    private static final String IMBUE_TEXT_NODE = "imbue-text";
    private static final String DEFAULT_IMBUE_TEXT = ChatComponents.GENERIC_SKILL + "%hero% has imbued %skill%!";
    private static final String UNIMBUE_TEXT_NODE = "unimbue-text";
    private static final String DEFAULT_UNIMBUE_TEXT = ChatComponents.GENERIC_SKILL + "%hero% no longer has %skill% imbued!";
    private static final String IMBUE_DURATION_NODE = "imbue-duration";
    private static final int DEFAULT_IMBUE_DURATION = 0;
    private static final String APPLY_COOLDOWN_ON_UNIMBUE_NODE = "apply-cooldown-on-unimbue";
    private static final boolean DEFAULT_APPLY_COOLDOWN_ON_UNIMBUE = false;
    private static final String IMBUE_DISPELLABLE_NODE = "imbue-dispellable";
    private static final boolean DEFAULT_IMBUE_DISPELLABLE = false;
    private String imbueText;
    private String unimbueText;

    public static boolean isWeaponImbued(Hero hero) {
        return SkillBaseWeaponImbue.getWeaponImbueEffect(hero) != null;
    }

    public static boolean isWeaponImbuedWithSkill(Hero hero, SkillBaseWeaponImbue skill) {
        WeaponImbueEffect weaponImbueEffect = SkillBaseWeaponImbue.getWeaponImbueEffect(hero);
        return weaponImbueEffect != null && weaponImbueEffect.getSkill().equals(skill);
    }

    public static void removeWeaponImbue(Hero hero) {
        hero.removeEffect(SkillBaseWeaponImbue.getWeaponImbueEffect(hero));
    }

    private static WeaponImbueEffect getWeaponImbueEffect(Hero hero) {
        Effect effect = hero.getEffect(WEAPON_IMBUE_EFFECT_NAME);
        return effect instanceof WeaponImbueEffect ? (WeaponImbueEffect)effect : null;
    }

    public SkillBaseWeaponImbue(Heroes plugin, String name) {
        super(plugin, name);
    }

    @Override
    public void init() {
        super.init();
        String imbueText = SkillConfigManager.getRaw((Skill)this, IMBUE_TEXT_NODE, DEFAULT_IMBUE_TEXT);
        this.setImbueText(imbueText.replace("%hero%", "$1").replace("%skill%", "$2"));
        String unimbueText = SkillConfigManager.getRaw((Skill)this, UNIMBUE_TEXT_NODE, DEFAULT_UNIMBUE_TEXT);
        this.setUnimbueText(unimbueText.replace("%hero%", "$1").replace("%skill%", "$2"));
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection node = super.getDefaultConfig();
        node.set(IMBUE_TEXT_NODE, (Object)DEFAULT_IMBUE_TEXT);
        node.set(UNIMBUE_TEXT_NODE, (Object)DEFAULT_UNIMBUE_TEXT);
        node.set(APPLY_COOLDOWN_ON_UNIMBUE_NODE, (Object)false);
        node.set(IMBUE_DISPELLABLE_NODE, (Object)false);
        return node;
    }

    public String getImbueText() {
        return this.imbueText;
    }

    public void setImbueText(String imbueText) {
        this.imbueText = imbueText;
    }

    public String getUnimbueText() {
        return this.unimbueText;
    }

    public void setUnimbueText(String unimbueText) {
        this.unimbueText = unimbueText;
    }

    private void broadcastImbueText(Hero hero) {
        Player player = hero.getPlayer();
        if (hero.hasEffectType(EffectType.SILENT_ACTIONS)) {
            Messaging.send((CommandSender)player, "    " + this.getImbueText(), player.getName(), this.getName());
        } else {
            this.broadcast(player.getLocation(), "    " + this.getImbueText(), player.getName(), this.getName());
        }
    }

    private void broadcastUnimbueText(Hero hero) {
        Player player = hero.getPlayer();
        if (hero.hasEffectType(EffectType.SILENT_ACTIONS)) {
            Messaging.send((CommandSender)player, "    " + this.getUnimbueText(), player.getName(), this.getName());
        } else {
            this.broadcast(player.getLocation(), "    " + this.getUnimbueText(), player.getName(), this.getName());
        }
    }

    protected boolean canApply(Hero hero, String[] args, Material weapon, boolean projectile) {
        return true;
    }

    protected boolean isImbueConsumedOnApplication(Hero hero, String[] args) {
        return true;
    }

    @Override
    public SkillResult use(Hero hero, String[] args) {
        SkillBaseWeaponImbue.removeWeaponImbue(hero);
        long imbueDuration = SkillConfigManager.getUseSetting(hero, (Skill)this, IMBUE_DURATION_NODE, 0, false);
        WeaponImbueEffect weaponImbueEffect = new WeaponImbueEffect(this, hero, args, imbueDuration);
        if (imbueDuration <= 0L) {
            weaponImbueEffect.setPersistent(true);
        }
        hero.addEffect(weaponImbueEffect);
        if (SkillConfigManager.getUseSetting(hero, (Skill)this, APPLY_COOLDOWN_ON_UNIMBUE_NODE, false)) {
            this.startRecast(hero, new RecastData("Imbue"));
        }
        return SkillResult.NORMAL;
    }

    protected void onImbue(Hero hero, String[] args) {
    }

    protected void onUnimbue(Hero hero, String[] args) {
    }

    protected abstract void apply(Hero var1, String[] var2, WeaponDamageEvent var3);

    private boolean isImbueDispellable(Hero hero) {
        return SkillConfigManager.getUseSetting(hero, (Skill)this, IMBUE_DISPELLABLE_NODE, false);
    }

    private static final class WeaponImbueEffect
    extends ExpirableEffect {
        private String[] args;

        WeaponImbueEffect(SkillBaseWeaponImbue skill, Hero hero, String[] args, long duration) {
            super((Skill)skill, SkillBaseWeaponImbue.WEAPON_IMBUE_EFFECT_NAME, hero.getPlayer(), duration);
            this.args = args;
            this.types.add(EffectType.IMBUE);
            this.types.add(EffectType.BENEFICIAL);
            if (skill.isImbueDispellable(hero)) {
                this.types.add(EffectType.DISPELLABLE);
            }
        }

        @Override
        public SkillBaseWeaponImbue getSkill() {
            return (SkillBaseWeaponImbue)this.skill;
        }

        String[] getArgs() {
            return this.args;
        }

        @Override
        public void applyToHero(Hero hero) {
            super.applyToHero(hero);
            for (Effect effect : hero.getEffects()) {
                if (effect.equals(this) || !effect.isType(EffectType.IMBUE)) continue;
                hero.removeEffect(effect);
            }
            this.getSkill().onImbue(hero, this.args);
            this.getSkill().broadcastImbueText(hero);
        }

        @Override
        public void removeFromHero(Hero hero) {
            this.getSkill().onUnimbue(hero, this.args);
            this.getSkill().broadcastUnimbueText(hero);
            this.getSkill().endRecast(hero);
        }
    }

    public static final class WeaponSkillListener
    implements Listener {
        private static final String PROJECTILE_WEAPON_IMBUE_META_KEY = "projectile-weapon-imbue";
        private final Heroes plugin;

        public WeaponSkillListener(Heroes plugin) {
            this.plugin = plugin;
        }

        @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
        private void onWeaponDamage(WeaponDamageEvent e) {
            if (e.getDamager() instanceof Hero) {
                Hero hero = (Hero)e.getDamager();
                Player player = hero.getPlayer();
                if (e.isProjectile()) {
                    if (e.getAttackerEntity().hasMetadata(PROJECTILE_WEAPON_IMBUE_META_KEY)) {
                        WeaponImbueEffect weaponSkillEffect = (WeaponImbueEffect)((MetadataValue)e.getAttackerEntity().getMetadata(PROJECTILE_WEAPON_IMBUE_META_KEY).get(0)).value();
                        weaponSkillEffect.getSkill().apply(hero, weaponSkillEffect.getArgs(), e);
                    }
                } else {
                    WeaponImbueEffect weaponImbueEffect;
                    Material weapon = NMSHandler.getInterface().getItemInMainHand(player.getInventory()).getType();
                    HeroClass heroClass = hero.getHeroClass();
                    HeroClass profession = hero.getSecondaryClass();
                    HeroClass race = hero.getRaceClass();
                    if ((hero.isAllowedWeapon(heroClass, weapon) || hero.isAllowedWeapon(profession, weapon) || hero.isAllowedWeapon(race, weapon)) && (weaponImbueEffect = SkillBaseWeaponImbue.getWeaponImbueEffect(hero)) != null && weaponImbueEffect.getSkill().canApply(hero, weaponImbueEffect.getArgs(), weapon, false)) {
                        weaponImbueEffect.getSkill().apply(hero, weaponImbueEffect.getArgs(), e);
                        if (weaponImbueEffect.getSkill().isImbueConsumedOnApplication(hero, weaponImbueEffect.getArgs())) {
                            hero.removeEffect(weaponImbueEffect);
                        }
                        weaponImbueEffect.getSkill().broadcastExecuteText(hero);
                    }
                }
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        private void onProjectileLaunch(ProjectileLaunchEvent e) {
            Projectile projectile = e.getEntity();
            if (projectile.getShooter() instanceof Player) {
                WeaponImbueEffect weaponImbueEffect;
                Player player = (Player)projectile.getShooter();
                Hero hero = this.plugin.getCharacterManager().getHero(player);
                Material weapon = NMSHandler.getInterface().getItemInMainHand(player.getInventory()).getType();
                HeroClass heroClass = hero.getHeroClass();
                HeroClass profession = hero.getSecondaryClass();
                HeroClass race = hero.getRaceClass();
                if ((hero.isAllowedWeapon(heroClass, weapon) || hero.isAllowedWeapon(profession, weapon) || hero.isAllowedWeapon(race, weapon)) && (weaponImbueEffect = SkillBaseWeaponImbue.getWeaponImbueEffect(hero)) != null && weaponImbueEffect.getSkill().canApply(hero, weaponImbueEffect.getArgs(), weapon, true)) {
                    projectile.setMetadata(PROJECTILE_WEAPON_IMBUE_META_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)weaponImbueEffect));
                    weaponImbueEffect.getSkill().broadcastExecuteText(hero);
                    if (weaponImbueEffect.getSkill().isImbueConsumedOnApplication(hero, weaponImbueEffect.getArgs())) {
                        hero.removeEffect(weaponImbueEffect);
                    }
                }
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        private void afterClassChange(AfterClassChangeEvent e) {
            this.validateWeaponSkillEffect(e.getHero());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        private void onLevelChange(HeroChangeLevelEvent e) {
            if (e.getTo() < e.getFrom()) {
                this.validateWeaponSkillEffect(e.getHero());
            }
        }

        private void validateWeaponSkillEffect(Hero hero) {
            WeaponImbueEffect weaponSkillEffect = (WeaponImbueEffect)hero.getEffect(SkillBaseWeaponImbue.WEAPON_IMBUE_EFFECT_NAME);
            if (weaponSkillEffect != null && !hero.canUseSkill(weaponSkillEffect.getSkill())) {
                hero.removeEffect(weaponSkillEffect);
            }
        }
    }
}

