/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.util.Util;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public abstract class SkillBaseSummonEntity
extends ActiveSkill {
    public SkillBaseSummonEntity(Heroes plugin, String name) {
        super(plugin, name);
        this.setDescription("100% chance to spawn 1 entity, $2% for 2, and $3% for 3.");
        this.setUsage("/skill entity");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("skill summonentity", "skill entity");
        this.setTypes(SkillType.SUMMONING, SkillType.SILENCEABLE);
    }

    @Override
    public String getDescription(Hero hero) {
        int chance2x = (int)(SkillConfigManager.getUseSetting(hero, (Skill)this, "chance-2x", 0.2, false) * 100.0 + SkillConfigManager.getUseSetting(hero, (Skill)this, "chance-2x-per-level", 0.0, false) * (double)hero.getHeroLevel(this));
        int chance3x = (int)(SkillConfigManager.getUseSetting(hero, (Skill)this, "chance-3x", 0.1, false) * 100.0 + SkillConfigManager.getUseSetting(hero, (Skill)this, "chance-3x-per-level", 0.0, false) * (double)hero.getHeroLevel(this));
        return this.getDescription().replace("$2", "" + chance2x).replace("$3", "" + chance3x);
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection node = super.getDefaultConfig();
        node.set("chance-2x", (Object)0.2);
        node.set("chance-3x", (Object)0.1);
        node.set(SkillSetting.MAX_DISTANCE.node(), (Object)20);
        node.set("chance-2x-per-level", (Object)0.0);
        node.set("chance-3x-per-level", (Object)0.0);
        return node;
    }

    @Override
    public SkillResult use(Hero hero, String[] args) {
        Player player = hero.getPlayer();
        double chance2x = SkillConfigManager.getUseSetting(hero, (Skill)this, "chance-2x", 0.2, false) + (double)((int)SkillConfigManager.getUseSetting(hero, (Skill)this, "chance-2x-per-level", 0.0, false) * hero.getHeroLevel(this));
        double chance3x = SkillConfigManager.getUseSetting(hero, (Skill)this, "chance-3x", 0.1, false) + (double)((int)SkillConfigManager.getUseSetting(hero, (Skill)this, "chance-3x-per-level", 0.0, false) * hero.getHeroLevel(this));
        int distance = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE, 20, false);
        Block targetBlock = player.getTargetBlock((Set)null, distance).getRelative(BlockFace.UP);
        this.summonEntity(hero, args, targetBlock);
        double chance = Util.nextRand();
        if (chance <= chance3x) {
            this.summonEntity(hero, args, targetBlock);
            this.summonEntity(hero, args, targetBlock);
        } else if (chance <= chance2x) {
            this.summonEntity(hero, args, targetBlock);
        }
        this.applySoundEffects(hero.getPlayer().getWorld(), hero.getPlayer());
        this.broadcastExecuteText(hero);
        return SkillResult.NORMAL;
    }

    protected Entity summonEntity(Hero hero, String[] args, Block targetBlock) {
        return hero.getPlayer().getWorld().spawnEntity(targetBlock.getLocation(), this.getEntityType(targetBlock));
    }

    protected abstract EntityType getEntityType(Block var1);

    protected void applySoundEffects(World world, Player player) {
    }
}

