/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class SkillBaseSteed
extends ActiveSkill {
    BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST};
    protected String steedName;
    @Deprecated
    protected Horse.Variant steedVariant;
    protected Horse.Color steedColor;
    private boolean redeemedReagent = false;

    protected SkillBaseSteed(Heroes plugin, String name) {
        super(plugin, name);
    }

    public SkillBaseSteed(Heroes plugin) {
        this(plugin, "Steed");
        this.setDescription("Summons a steed for $1");
        this.setIdentifiers("skill steed");
        this.setUsage("/skill steed");
        this.setArgumentRange(0, 0);
        this.steedName = "Steed";
        this.steedColor = Horse.Color.BROWN;
        new SteedListener();
    }

    @Override
    public SkillResult use(Hero hero, String[] args) {
        Player heroP = hero.getPlayer();
        if (heroP.isInsideVehicle()) {
            heroP.sendMessage(ChatColor.RED + "Cannot use while mounted!");
            return SkillResult.FAIL;
        }
        Location loc = heroP.getLocation();
        for (BlockFace face : this.faces) {
            if (loc.getBlock().getRelative(face).getType() == Material.AIR && loc.getBlock().getRelative(face).getRelative(BlockFace.UP).getType() == Material.AIR) continue;
            heroP.sendMessage(ChatColor.RED + "A steed needs breathing room!");
            return SkillResult.FAIL;
        }
        this.redeemedReagent = false;
        final Horse horse = (Horse)loc.getWorld().spawn(loc, Horse.class);
        Monster m = this.plugin.getCharacterManager().getMonster((LivingEntity)horse);
        m.setMaxHealth(1000.0);
        m.getEntity().setCustomName(hero.getName() + "'s " + this.steedName);
        horse.setAdult();
        HorseInventory hInv = horse.getInventory();
        hInv.setSaddle(new ItemStack(Material.SADDLE));
        horse.setTamed(true);
        horse.setColor(this.steedColor);
        horse.addPassenger((Entity)heroP);
        int summonDuration = SkillConfigManager.getUseSetting(hero, (Skill)this, "summon-duration", 60, false);
        m.addEffect(new ExpirableEffect((Skill)this, this.plugin, "HorseExpiry", heroP, summonDuration * 1000){

            @Override
            public void removeFromMonster(Monster m) {
                for (Entity passenger : m.getEntity().getPassengers()) {
                    if (!(passenger instanceof Player)) continue;
                    Hero hero = this.plugin.getCharacterManager().getHero((Player)passenger);
                    boolean consumeReagent = SkillConfigManager.getUseSetting(hero, (Skill)SkillBaseSteed.this, "consume-reagent", true);
                    ItemStack itemStack = SkillBaseSteed.this.getReagentCost(hero);
                    if (itemStack != null && itemStack.getAmount() > 0 && !consumeReagent && !SkillBaseSteed.this.redeemedReagent) {
                        ItemStack horseSaddle = horse.getInventory().getSaddle();
                        if (horseSaddle == null || horseSaddle.getAmount() == 0) break;
                        Player player = (Player)passenger;
                        HashMap leftOvers = player.getInventory().addItem(new ItemStack[]{itemStack});
                        player.sendMessage(ChatColor.GREEN + "Your saddle has been returned!");
                        for (Map.Entry entry : leftOvers.entrySet()) {
                            player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)entry.getValue());
                            player.sendMessage("Not enough inventory space. Your saddle has been dropped at your feet!");
                        }
                        SkillBaseSteed.this.redeemedReagent = true;
                    }
                    ((Player)passenger).sendMessage("Your steed has vanished!");
                    break;
                }
                m.getEntity().remove();
            }
        });
        this.broadcastExecuteText(hero);
        return SkillResult.NORMAL;
    }

    @Override
    public String getDescription(Hero hero) {
        int summonDuration = SkillConfigManager.getUseSetting(hero, (Skill)this, "summon-duration", 60, false);
        return this.getDescription().replace("$1", "" + summonDuration);
    }

    protected class SteedListener
    implements Listener {
        public SteedListener() {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)SkillBaseSteed.this.plugin);
        }

        @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
        public void onVehicleExit(VehicleExitEvent event) {
            if (event.getVehicle().getType() == EntityType.HORSE) {
                Effect e;
                Horse horse = (Horse)event.getVehicle();
                Monster m = SkillBaseSteed.this.plugin.getCharacterManager().getMonster((LivingEntity)horse);
                if (m.hasEffect("HorseExpiry") && (e = m.getEffect("HorseExpiry")) instanceof ExpirableEffect) {
                    for (Entity passenger : m.getEntity().getPassengers()) {
                        ItemStack horseSaddle;
                        if (!(passenger instanceof Player)) continue;
                        Hero hero = SkillBaseSteed.this.plugin.getCharacterManager().getHero((Player)passenger);
                        boolean consumeReagent = SkillConfigManager.getUseSetting(hero, (Skill)SkillBaseSteed.this, "consume-reagent", true);
                        ItemStack itemStack = SkillBaseSteed.this.getReagentCost(hero);
                        if (itemStack == null || itemStack.getAmount() <= 0 || consumeReagent || SkillBaseSteed.this.redeemedReagent || (horseSaddle = horse.getInventory().getSaddle()) == null || horseSaddle.getAmount() == 0) break;
                        Player player = (Player)passenger;
                        HashMap leftOvers = player.getInventory().addItem(new ItemStack[]{itemStack});
                        player.sendMessage(ChatColor.GREEN + "Your saddle has been returned!");
                        for (Map.Entry entry : leftOvers.entrySet()) {
                            player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)entry.getValue());
                            player.sendMessage("Not enough inventory space. Your saddle has been dropped at your feet!");
                        }
                        SkillBaseSteed.this.redeemedReagent = true;
                        break;
                    }
                    ((ExpirableEffect)e).expire();
                }
            }
        }

        @EventHandler
        public void onEntityDamage(EntityDamageEvent event) {
            Effect e;
            Monster m;
            if (event.getEntityType() == EntityType.HORSE && event.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION && (m = SkillBaseSteed.this.plugin.getCharacterManager().getMonster((LivingEntity)((Horse)event.getEntity()))).hasEffect("HorseExpiry") && (e = m.getEffect("HorseExpiry")) instanceof ExpirableEffect) {
                for (Entity passenger : m.getEntity().getPassengers()) {
                    if (!(passenger instanceof Player)) continue;
                    ((Player)passenger).sendMessage(ChatColor.RED + "A steed needs breathing room!");
                }
                ((ExpirableEffect)e).expire();
            }
        }

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            Effect e;
            Monster m;
            Player player = event.getPlayer();
            if (player.isInsideVehicle() && player.getVehicle().getType() == EntityType.HORSE && (m = SkillBaseSteed.this.plugin.getCharacterManager().getMonster((LivingEntity)((Horse)player.getVehicle()))).hasEffect("HorseExpiry") && (e = m.getEffect("HorseExpiry")) instanceof ExpirableEffect) {
                m.getEntity().eject();
            }
        }
    }
}

