/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.skill.TargettedSkill;
import de.slikey.effectlib.EffectManager;
import de.slikey.effectlib.EffectType;
import de.slikey.effectlib.effect.ConeEffect;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public abstract class SkillBaseSpike
extends TargettedSkill {
    private static final Vector DOWN = new Vector(0, -1, 0);
    private static final int PARTICLES_PER_HEIGHT = 10;
    private static final int PARTICLES_PER_RADIUS = 10;
    private static final double ANGULAR_VELOCITY_PI_DIVISOR_PER_RADIUS = 10.0;
    private static final long TICK_RISE_TIME = 5L;
    protected static final double BLOCK_SPIKE_RADIUS = 0.5;
    protected static final String SPIKE_HEIGHT_NODE = "spike-height";
    protected static final String DOES_KNOCK_UP_NODE = "does-knock-up";
    protected static final String KNOCK_UP_STRENGTH_NODE = "knock-up-strength";

    public SkillBaseSpike(Heroes plugin, String name) {
        super(plugin, name);
    }

    private static ConeEffect createCone(EffectManager em, Particle particle, double height, double radius) {
        ConeEffect effect = new ConeEffect(em);
        effect.particle = particle;
        effect.angularVelocity = Math.PI / (radius * 10.0);
        effect.particlesCone = effect.particles = 1 + (int)(height * 10.0) + (int)(radius * 10.0);
        effect.lengthGrow = (float)height / (float)effect.particles;
        effect.radiusGrow = (float)radius / (float)effect.particles;
        effect.asynchronous = true;
        effect.type = EffectType.INSTANT;
        effect.iterations = 1;
        return effect;
    }

    private static ConeEffect createCone(EffectManager em, Particle particle, double height, double radius, Color color) {
        ConeEffect effect = SkillBaseSpike.createCone(em, particle, height, radius);
        effect.color = color;
        return effect;
    }

    private void renderSpike(final Location location, final double height, final ConeEffectProvider provider) {
        location.setDirection(DOWN);
        new BukkitRunnable(){
            private int life = 0;

            public void run() {
                EffectManager em = new EffectManager((Plugin)SkillBaseSpike.this.plugin);
                double scaledHeight = height / 5.0 * (double)this.life;
                ConeEffect effect = provider.provide(em, scaledHeight);
                effect.setLocation(location.clone().add(0.0, scaledHeight, 0.0));
                effect.start();
                em.disposeOnTermination();
                if ((long)(++this.life) > 5L) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    protected void renderSpike(Location location, double height, final double radius, final Particle particle, final Color color) {
        this.renderSpike(location.clone(), height, new ConeEffectProvider(){

            @Override
            public ConeEffect provide(EffectManager em, double scaledHeight) {
                return SkillBaseSpike.createCone(em, particle, scaledHeight, radius, color);
            }
        });
    }

    protected void renderSpike(Location location, double height, final double radius, final Particle particle) {
        this.renderSpike(location.clone(), height, new ConeEffectProvider(){

            @Override
            public ConeEffect provide(EffectManager em, double scaledHeight) {
                return SkillBaseSpike.createCone(em, particle, scaledHeight, radius);
            }
        });
    }

    protected void renderSpikeOnBlock(Block block, double height, Particle particle, Color color) {
        this.renderSpike(block.getLocation().add(0.5, 1.0, 0.5), height, 0.5, particle, color);
    }

    protected void renderSpikeOnBlock(Block block, double height, Particle particle) {
        this.renderSpike(block.getLocation().add(0.5, 1.0, 0.5), height, 0.5, particle);
    }

    private abstract class ConeEffectProvider {
        private ConeEffectProvider() {
        }

        public abstract ConeEffect provide(EffectManager var1, double var2);
    }
}

