/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.EffectAddEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import de.slikey.effectlib.EffectManager;
import de.slikey.effectlib.effect.SphereEffect;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class SkillBaseSphere
extends ActiveSkill {
    public SkillBaseSphere(Heroes plugin, String name) {
        super(plugin, name);
    }

    protected void castSphere(final Hero hero, final double radius, final SphereActions sphereActions) {
        final Set<Entity> possibleTargets = SkillBaseSphere.getEntitiesInChunks(hero.getPlayer().getLocation(), (int)(radius + 16.0) / 16);
        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (final Entity target : possibleTargets) {
                    if (!(hero.getPlayer().getLocation().distanceSquared(target.getLocation()) <= radius * radius)) continue;
                    Bukkit.getScheduler().runTask((Plugin)SkillBaseSphere.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            sphereActions.sphereTargetAction(hero, target);
                        }
                    });
                }
            }
        });
    }

    private static Set<Entity> getEntitiesInChunks(Location l, int chunkRadius) {
        HashSet<Entity> entities = new HashSet<Entity>();
        Chunk origin = l.getChunk();
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                Collections.addAll(entities, origin.getWorld().getChunkAt(origin.getX() + x, origin.getZ() + z).getEntities());
            }
        }
        return entities;
    }

    protected void renderSphere(Location center, double radius, int particlesPerRadius, Particle particle, Color color) {
        EffectManager em = new EffectManager((Plugin)this.plugin);
        SphereEffect effect = new SphereEffect(em);
        effect.setLocation(center);
        effect.radius = radius;
        effect.particle = particle;
        effect.color = color;
        effect.particles = (int)radius * particlesPerRadius;
        effect.type = de.slikey.effectlib.EffectType.INSTANT;
        effect.iterations = 1;
        effect.asynchronous = true;
        effect.start();
        em.disposeOnTermination();
    }

    protected void renderSphere(Location center, double radius, int particlesPerRadius, Particle particle) {
        this.renderSphere(center, radius, particlesPerRadius, particle, Color.WHITE);
    }

    public void renderSphere(Location center, double radius, Particle particle, Color color) {
        this.renderSphere(center, radius, 100, particle, color);
    }

    protected void renderSphere(Location center, double radius, Particle particle) {
        this.renderSphere(center, radius, 100, particle);
    }

    protected void applyAreaSphereEffect(Hero hero, long period, long duration, double radius, SphereActions sphereActions, String applyText, String expireText, EffectType ... effectTypes) {
        AreaSphereEffect effect = new AreaSphereEffect(hero.getPlayer(), period, duration, radius, sphereActions, applyText, expireText);
        Collections.addAll(effect.types, effectTypes);
        hero.addEffect(effect);
    }

    protected void applyAreaSphereEffect(Hero hero, long period, long duration, double radius, SphereActions sphereActions, EffectType ... effectTypes) {
        this.applyAreaSphereEffect(hero, period, duration, radius, sphereActions, (String)null, (String)null, effectTypes);
    }

    protected boolean isAreaSphereApplied(Hero hero) {
        return hero.hasEffect(this.getName());
    }

    public static interface SphereActions {
        public void sphereTickAction(Hero var1, AreaSphereEffect var2);

        public void sphereTargetAction(Hero var1, Entity var2);
    }

    protected final class AreaSphereEffect
    extends PeriodicExpirableEffect {
        protected double radius;
        protected final SphereActions sphereActions;

        private AreaSphereEffect(Player applier, long period, long duration, double radius, SphereActions sphereActions, String applyText, String expireText) {
            super((Skill)SkillBaseSphere.this, SkillBaseSphere.this.getName(), applier, period, duration, applyText, expireText);
            this.radius = radius;
            this.sphereActions = sphereActions;
            this.types.add(EffectType.AREA_OF_EFFECT);
            this.types.add(EffectType.BENEFICIAL);
            this.types.add(EffectType.MAGIC);
        }

        private AreaSphereEffect(Player applier, long period, long duration, double radius, SphereActions sphereActions) {
            this(applier, period, duration, radius, sphereActions, null, null);
        }

        public double getRadius() {
            return this.radius;
        }

        public void setRadius(double radius) {
            this.radius = radius;
        }

        @Override
        public void tickHero(Hero hero) {
            this.sphereActions.sphereTickAction(hero, this);
            SkillBaseSphere.this.castSphere(hero, this.radius, this.sphereActions);
        }

        @Override
        public void tickMonster(Monster monster) {
            throw new UnsupportedOperationException("Area Sphere tick on monster");
        }
    }

    private final class SphereControlListeners
    implements Listener {
        private SphereControlListeners() {
        }

        @EventHandler(priority=EventPriority.MONITOR)
        private void OnEffectAdd(EffectAddEvent e) {
            if (e.getCharacter().hasEffect(SkillBaseSphere.this.getName()) && e.getEffect().isType(EffectType.SILENCE)) {
                e.getCharacter().removeEffect(e.getCharacter().getEffect(SkillBaseSphere.this.getName()));
            }
        }
    }
}

