/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.RegionUtil;
import com.herocraftonline.townships.users.TownshipsUser;
import com.herocraftonline.townships.users.UserManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public abstract class SkillBaseRunestone
extends ActiveSkill {
    private boolean herotowns = false;
    private boolean towny = false;
    private boolean worldguard = false;
    private boolean townships = false;
    protected int defaultMaxUses;
    protected long defaultDelay;
    protected String displayName;
    protected ChatColor displayNameColor;
    protected Material runestoneMaterial;

    protected SkillBaseRunestone(Heroes plugin, String name) {
        super(plugin, name);
        try {
            if (Bukkit.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
                this.worldguard = true;
            }
            if (Bukkit.getServer().getPluginManager().getPlugin("Townships") != null) {
                this.townships = true;
            }
        }
        catch (Exception e) {
            Heroes.log(Level.SEVERE, "Could not get WorldGuard or Townships! Region checking may not work!");
        }
    }

    public SkillBaseRunestone(Heroes plugin) {
        this(plugin, "Runestone");
        this.setDescription("You imbue a redstone block with a Runestone. Runestones $1");
        this.setUsage("/skill runestone");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("skill runestone");
        this.setTypes(SkillType.ITEM_MODIFYING, SkillType.SILENCEABLE);
        this.defaultMaxUses = 2;
        this.defaultDelay = 5000L;
        this.displayName = "Runestone";
        this.displayNameColor = ChatColor.GREEN;
        this.runestoneMaterial = Material.REDSTONE_BLOCK;
        new RunestoneListener();
    }

    @Override
    public String getDescription(Hero hero) {
        int maxUses = SkillConfigManager.getUseSetting(hero, (Skill)this, "max-uses", this.defaultMaxUses, false);
        Object maxUsesString = "";
        maxUsesString = maxUses > -1 ? "have a maximum use limit of " + maxUses + "." : "have no usage limit.";
        return this.getDescription().replace("$1", (CharSequence)maxUsesString);
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection node = super.getDefaultConfig();
        node.set(SkillSetting.NO_COMBAT_USE.node(), (Object)true);
        node.set(SkillSetting.DELAY.node(), (Object)this.defaultDelay);
        node.set("max-uses", (Object)this.defaultMaxUses);
        return node;
    }

    @Override
    public SkillResult use(Hero hero, String[] args) {
        Player player = hero.getPlayer();
        ItemStack heldItem = NMSHandler.getInterface().getItemInMainHand(player.getInventory());
        if (heldItem.getType() != this.runestoneMaterial) {
            String friendlyName = MaterialUtil.getFriendlyName(this.runestoneMaterial);
            Messaging.send((CommandSender)player, "You must be holding a " + friendlyName + " in order to imbue Runestones.", new Object[0]);
            return new SkillResult(SkillResult.ResultType.MISSING_REAGENT, false, new Object[0]);
        }
        ItemMeta metaData = heldItem.getItemMeta();
        List loreData = metaData.getLore();
        if (loreData == null) {
            Location location = player.getLocation();
            if (!this.ignoreRegionPlugins()) {
                TownshipsUser user;
                if (this.herotowns) {
                    // empty if block
                }
                if (this.towny) {
                    // empty if block
                }
                if (this.townships && !(user = UserManager.fromOfflinePlayer((OfflinePlayer)player)).canBuild(location)) {
                    Messaging.send((CommandSender)player, "You cannot imbue a Runestone in a Region you have no access to!", new Object[0]);
                    return SkillResult.FAIL;
                }
                if (this.worldguard && !RegionUtil.IsAbleToBuildInRegion(player, location)) {
                    Messaging.send((CommandSender)player, "You cannot imbue a Runestone in a Region you have no access to!", new Object[0]);
                    return SkillResult.FAIL;
                }
            }
            Object worldName = location.getWorld().getName();
            worldName = ((String)worldName).substring(0, 1).toUpperCase() + ((String)worldName).substring(1);
            if (StringUtils.isNotEmpty((String)this.plugin.getServerName())) {
                worldName = this.plugin.getServerName() + "," + (String)worldName;
            }
            metaData.setDisplayName(this.displayNameColor + this.displayName);
            List<String> newLore = this.getNewRunestoneLore(hero, location, (String)worldName);
            metaData.setLore(newLore);
            int actualAmount = heldItem.getAmount();
            if (actualAmount > 1) {
                heldItem.setAmount(1);
            }
            heldItem.setItemMeta(metaData);
            player.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, player.getLocation(), 10, 0.0, 0.0, 0.0, 1.0);
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WITHER_AMBIENT, 0.5f, 1.0f);
            this.broadcastExecuteText(hero);
            if (actualAmount > 1) {
                PlayerInventory inventory = player.getInventory();
                HashMap leftOvers = inventory.addItem(new ItemStack[]{new ItemStack(this.runestoneMaterial, actualAmount - 1)});
                for (Map.Entry entry : leftOvers.entrySet()) {
                    player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)entry.getValue());
                    Messaging.send((CommandSender)player, "Items have been dropped at your feet!", new Object[0]);
                }
            }
            return SkillResult.NORMAL;
        }
        Messaging.send((CommandSender)player, "You cannot imbue a Rune to that item!", new Object[0]);
        return SkillResult.FAIL;
    }

    protected boolean ignoreRegionPlugins() {
        return true;
    }

    @Nonnull
    protected List<String> getNewRunestoneLore(Hero creatorHero, Location location, String worldName) {
        Player player = creatorHero.getPlayer();
        String locationInformation = ChatColor.AQUA + worldName + ": " + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ();
        int numUses = SkillConfigManager.getUseSetting(creatorHero, (Skill)this, "max-uses", this.defaultMaxUses, false);
        Object runestoneUsesInformation = "";
        runestoneUsesInformation = numUses > -1 ? ChatColor.AQUA + "Uses: " + numUses + "/" + numUses : ChatColor.AQUA + "Uses: Unlimited";
        String imbuedByInformation = ChatColor.DARK_PURPLE + "Imbued by " + player.getName();
        return Arrays.asList(locationInformation, runestoneUsesInformation, imbuedByInformation);
    }

    protected class RunestoneListener
    implements Listener {
        public RunestoneListener() {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)SkillBaseRunestone.this.plugin);
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onBlockPlace(BlockPlaceEvent event) {
            if (event.getItemInHand().getType() != SkillBaseRunestone.this.runestoneMaterial) {
                return;
            }
            ItemStack item = event.getItemInHand();
            ItemMeta metaData = item.getItemMeta();
            if (metaData == null || metaData.getDisplayName() == null) {
                return;
            }
            if (!metaData.getDisplayName().contains(SkillBaseRunestone.this.displayName)) {
                return;
            }
            Messaging.send((CommandSender)event.getPlayer(), "You cannot place Runestone blocks!", new Object[0]);
            event.setCancelled(true);
        }
    }
}

