/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.google.common.base.Preconditions;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.util.BlockVector;
import org.bukkit.util.NumberConversions;

public abstract class SkillBaseMassBlockEffector
extends ActiveSkill {
    public SkillBaseMassBlockEffector(Heroes plugin, String name) {
        super(plugin, name);
    }

    protected static final class BlockRegion
    implements Iterable<BlockState> {
        private final int ox;
        private final int oy;
        private final int oz;
        private final BlockState[][][] region;

        public static BlockRegion bounds(Block center, int boundsX, int boundsY, int boundsZ) {
            return new BlockRegion(center.getRelative(-boundsX, -boundsY, -boundsZ), boundsX * 2 + 1, boundsY * 2 + 1, boundsZ * 2 + 1);
        }

        public static BlockRegion bounds(Block center, int bounds) {
            return BlockRegion.bounds(center, bounds, bounds, bounds);
        }

        public BlockRegion(Block origin, int sizeX, int sizeY, int sizeZ) {
            Preconditions.checkNotNull((Object)origin, (Object)"origin");
            Preconditions.checkArgument((sizeX > 0 ? 1 : 0) != 0, (Object)"sizeX is non positive");
            Preconditions.checkArgument((sizeY > 0 ? 1 : 0) != 0, (Object)"sizeY is non positive");
            Preconditions.checkArgument((sizeZ > 0 ? 1 : 0) != 0, (Object)"sizeZ is non positive");
            World world = origin.getWorld();
            if (origin.getY() + sizeY > world.getMaxHeight()) {
                sizeY = world.getMaxHeight() - origin.getY();
            }
            this.ox = origin.getX();
            this.oy = origin.getY();
            this.oz = origin.getZ();
            this.region = new BlockState[sizeX][sizeY][sizeZ];
            for (int x = 0; x < sizeX; ++x) {
                for (int y = 0; y < sizeX; ++y) {
                    for (int z = 0; z < sizeX; ++z) {
                        this.region[x][y][z] = world.getBlockAt(this.ox + x, this.oy + y, this.oz + z).getState();
                    }
                }
            }
        }

        public int getOriginX() {
            return this.ox;
        }

        public int getOriginY() {
            return this.oy;
        }

        public int getOriginZ() {
            return this.oz;
        }

        public BlockVector getOrigin() {
            return new BlockVector(this.getOriginX(), this.getOriginY(), this.getOriginZ());
        }

        public int getSizeX() {
            return this.region.length;
        }

        public int getSizeY() {
            return this.region[0].length;
        }

        public int getSizeZ() {
            return this.region[0][0].length;
        }

        public BlockState getBlock(int ix, int iy, int iz) throws ArrayIndexOutOfBoundsException {
            return this.region[ix][iy][iz];
        }

        public BlockState getRelative(BlockState block, int x, int y, int z) {
            int rx = block.getX() - this.ox + x;
            int ry = block.getY() - this.oy + y;
            int rz = block.getZ() - this.oz + z;
            if (rx < 0 || rx >= this.getSizeX() || ry < 0 || ry >= this.getSizeY() || rz < 0 || rz >= this.getSizeZ()) {
                return null;
            }
            return this.getBlock(rx, ry, rz);
        }

        public BlockState getRelative(BlockState block, BlockFace face, int distance) {
            return this.getRelative(block, face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
        }

        public BlockState getRelative(BlockState block, BlockFace face) {
            return this.getRelative(block, face, 1);
        }

        public BlockState getCenter() {
            return this.getBlock(NumberConversions.ceil((double)((double)this.getSizeX() / 2.0)), NumberConversions.ceil((double)((double)this.getSizeY() / 2.0)), NumberConversions.ceil((double)((double)this.getSizeZ() / 2.0)));
        }

        @Override
        public Iterator<BlockState> iterator() {
            return new Iterator<BlockState>(){
                private int x = 0;
                private int y = 0;
                private int z = 0;

                @Override
                public boolean hasNext() {
                    return this.z < this.getSizeZ() || this.y < this.getSizeY() || this.x < this.getSizeX();
                }

                @Override
                public BlockState next() {
                    BlockState result;
                    try {
                        result = this.getBlock(this.x, this.y, this.z);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        throw new NoSuchElementException();
                    }
                    if (++this.z == this.getSizeZ()) {
                        this.z = 0;
                        if (++this.y == this.getSizeY()) {
                            this.y = 0;
                            ++this.x;
                        }
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }
    }

    public static interface BlockProcessor {
        public void process(Hero var1, BlockState var2, BlockRegion var3);
    }
}

