/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.TargettedSkill;
import de.slikey.effectlib.Effect;
import de.slikey.effectlib.EffectManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class SkillBaseMarkedTeleport
extends TargettedSkill {
    protected static final String MANA_ACTIVATION_NODE = "mana-activation";
    protected static final String PRESERVE_LOOK_DIRECTION_NODE = "preserve-look-direction";
    protected static final String PRESERVE_VELOCITY_NODE = "preserve-velocity";
    protected static final String RE_CAST_DELAY_NODE = "re-cast-delay";
    private final Map<UUID, Marker> activeMarkers = new HashMap<UUID, Marker>();
    private final Boolean selfTarget;
    private final EffectType[] markerEffectTypes;
    private final Particle particle;
    private final Color[] colors;

    public SkillBaseMarkedTeleport(Heroes plugin, String name, Boolean selfTarget, EffectType[] markerEffectTypes, Particle particle, Color[] colors) {
        super(plugin, name);
        this.selfTarget = selfTarget;
        this.markerEffectTypes = markerEffectTypes;
        this.particle = particle;
        this.colors = colors;
    }

    public SkillBaseMarkedTeleport(Heroes plugin, String name, Boolean selfTarget, EffectType[] markerEffectTypes, Particle particle) {
        this(plugin, name, selfTarget, markerEffectTypes, particle, new Color[0]);
    }

    public SkillBaseMarkedTeleport(Heroes plugin, String name, Boolean selfTarget, Particle particle) {
        this(plugin, name, selfTarget, new EffectType[0], particle, new Color[0]);
    }

    public SkillBaseMarkedTeleport(Heroes plugin, String name, Boolean selfTarget, Particle particle, Color[] colors) {
        this(plugin, name, selfTarget, new EffectType[0], particle, colors);
    }

    @Override
    public final SkillResult use(Hero hero, String[] args) {
        Marker marker = this.activeMarkers.get(hero.getPlayer().getUniqueId());
        if (marker != null) {
            marker.activate();
            return SkillResult.INVALID_TARGET_NO_MSG;
        }
        return super.use(hero, args);
    }

    @Override
    public final SkillResult use(Hero hero, LivingEntity target, String[] strings) {
        Player player = hero.getPlayer();
        if (this.selfTarget != null && this.selfTarget == (player != target)) {
            return SkillResult.INVALID_TARGET_NO_MSG;
        }
        this.broadcastExecuteText(hero, target);
        int manaCost = SkillConfigManager.getUseSetting(hero, (Skill)this, MANA_ACTIVATION_NODE, 0, false);
        if (manaCost > hero.getMana()) {
            return SkillResult.LOW_MANA;
        }
        hero.setMana(hero.getMana() - manaCost);
        CharacterTemplate targetCt = this.plugin.getCharacterManager().getCharacter(target);
        MarkedTeleportEffect effect = new MarkedTeleportEffect(player, SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.DURATION, 10000, false), SkillConfigManager.getUseSetting(hero, (Skill)this, PRESERVE_LOOK_DIRECTION_NODE, true), SkillConfigManager.getUseSetting(hero, (Skill)this, PRESERVE_VELOCITY_NODE, true));
        Collections.addAll(effect.types, this.markerEffectTypes);
        targetCt.addEffect(effect);
        return SkillResult.INVALID_TARGET_NO_MSG;
    }

    protected void onMarkerCreate(Marker marker) {
    }

    protected void onMarkerRemove(Marker marker) {
    }

    protected void onMarkerActivate(Marker marker, long activateTime) {
    }

    private void applyCooldown(Hero hero) {
        hero.setCooldown(this.getName(), System.currentTimeMillis() + (long)SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.COOLDOWN, 0, false));
    }

    protected final class Marker {
        private final Hero hero;
        private final CharacterTemplate target;
        private final Location location;
        private final boolean preserveVelocity;
        private final boolean preserveLookDirection;
        private final RingEffect effect;
        private final long createTime = System.currentTimeMillis();
        private boolean activated = false;

        private Marker(Hero hero, CharacterTemplate target, boolean preserveVelocity, boolean preserveLookDirection) {
            this.hero = hero;
            this.target = target;
            this.location = target.getEntity().getLocation();
            this.preserveVelocity = preserveVelocity;
            this.preserveLookDirection = preserveLookDirection;
            EffectManager em = new EffectManager((Plugin)SkillBaseMarkedTeleport.this.plugin);
            this.effect = new RingEffect(em);
            this.effect.setLocation(this.location.clone().add(0.0, 0.1, 0.0));
            this.effect.start();
            em.disposeOnTermination();
        }

        public Hero getHero() {
            return this.hero;
        }

        public CharacterTemplate getTarget() {
            return this.target;
        }

        public Location getLocation() {
            return this.location.clone();
        }

        public boolean isVelocityPreserved() {
            return this.preserveVelocity;
        }

        public boolean isLookDirectionPreserved() {
            return this.preserveLookDirection;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public boolean isActivated() {
            return this.activated;
        }

        private void activate() {
            if (!this.isActivated()) {
                long reCastDelay = SkillConfigManager.getUseSetting(this.hero, (Skill)SkillBaseMarkedTeleport.this, SkillBaseMarkedTeleport.RE_CAST_DELAY_NODE, 0, false);
                if (System.currentTimeMillis() - this.createTime > reCastDelay) {
                    SkillBaseMarkedTeleport.this.onMarkerActivate(this, System.currentTimeMillis());
                    this.target.getEntity().getWorld().playSound(this.target.getEntity().getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 0.4f, 0.1f);
                    this.target.getEntity().getWorld().playSound(this.location, Sound.ENTITY_ENDERMAN_TELEPORT, 0.4f, 0.1f);
                    Vector currentVelocity = this.target.getEntity().getVelocity();
                    if (this.preserveLookDirection) {
                        this.location.setDirection(this.target.getEntity().getLocation().getDirection());
                    }
                    this.target.getEntity().teleport(this.location, PlayerTeleportEvent.TeleportCause.PLUGIN);
                    if (this.preserveVelocity) {
                        this.target.getEntity().setVelocity(currentVelocity);
                    }
                    this.activated = true;
                    this.target.removeEffect(this.target.getEffect(SkillBaseMarkedTeleport.this.getName()));
                }
            }
        }

        private final class RingEffect
        extends Effect {
            public double radius;
            public double particles;
            private int colorIndex;

            public RingEffect(EffectManager effectManager) {
                super(effectManager);
                this.radius = 0.5;
                this.particles = 9.0;
                this.colorIndex = 0;
                this.infinite();
                this.asynchronous = true;
                this.color = Color.WHITE;
                this.period = 2;
            }

            public void onRun() {
                double inc = Math.PI * 2 / this.particles;
                for (double angle = 0.0; angle < Math.PI * 4; angle += inc) {
                    if (SkillBaseMarkedTeleport.this.colors.length > 0) {
                        if (this.colorIndex >= SkillBaseMarkedTeleport.this.colors.length) {
                            this.colorIndex = 0;
                        }
                        this.color = SkillBaseMarkedTeleport.this.colors[this.colorIndex++];
                    }
                    Vector v = new Vector(Math.cos(angle), 0.0, Math.sin(angle)).multiply(this.radius);
                    this.display(SkillBaseMarkedTeleport.this.particle, this.getLocation().add(v));
                    this.getLocation().subtract(v);
                }
            }
        }
    }

    private final class MarkedTeleportEffect
    extends ExpirableEffect {
        private final boolean preserveLookDirection;
        private final boolean preserveVelocity;

        public MarkedTeleportEffect(Player applier, long duration, boolean preserveLookDirection, boolean preserveVelocity) {
            super((Skill)SkillBaseMarkedTeleport.this, SkillBaseMarkedTeleport.this.getName(), applier, duration);
            this.preserveLookDirection = preserveLookDirection;
            this.preserveVelocity = preserveVelocity;
            this.types.add(EffectType.DISPELLABLE);
            this.types.add(EffectType.MAGIC);
            this.types.add(EffectType.SUMMON);
        }

        @Override
        public void applyToHero(Hero hero) {
            super.applyToHero(hero);
            this.createMarker(hero);
        }

        @Override
        public void applyToMonster(Monster monster) {
            super.applyToMonster(monster);
            this.createMarker(monster);
        }

        @Override
        public void removeFromHero(Hero hero) {
            super.removeFromHero(hero);
            this.removeMarker();
        }

        @Override
        public void removeFromMonster(Monster monster) {
            super.removeFromMonster(monster);
            this.removeMarker();
        }

        private void createMarker(CharacterTemplate target) {
            Marker marker = new Marker(this.plugin.getCharacterManager().getHero(this.getApplier()), target, this.preserveVelocity, this.preserveLookDirection);
            SkillBaseMarkedTeleport.this.activeMarkers.put(this.getApplier().getUniqueId(), marker);
            target.getEntity().getWorld().playSound(target.getEntity().getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 0.4f, 100000.0f);
            SkillBaseMarkedTeleport.this.onMarkerCreate(marker);
        }

        private void removeMarker() {
            Marker marker = SkillBaseMarkedTeleport.this.activeMarkers.remove(this.getApplier().getUniqueId());
            if (marker != null) {
                SkillBaseMarkedTeleport.this.applyCooldown(marker.hero);
                marker.effect.cancel();
                if (!marker.activated) {
                    marker.getTarget().getEntity().getWorld().playSound(marker.location, Sound.ENTITY_GENERIC_BURN, 0.4f, 1.0E-4f);
                }
                SkillBaseMarkedTeleport.this.onMarkerRemove(marker);
            }
        }
    }
}

