/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.characters.skill.TargettedSkill;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Util;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public abstract class SkillBaseHeal
extends TargettedSkill {
    protected SkillBaseHeal(Heroes plugin, String name) {
        super(plugin, name);
    }

    public SkillBaseHeal(Heroes plugin) {
        this(plugin, "Heal");
        this.setDescription("Heal your target, restoring $1 of their health. You are only healed for $2 health from this ability. You cannot use this ability in combat.");
        this.setUsage("/skill heal <target>");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("skill heal");
        this.setTypes(SkillType.ABILITY_PROPERTY_LIGHT, SkillType.HEALING, SkillType.SILENCEABLE);
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection config = super.getDefaultConfig();
        config.set(SkillSetting.IS_SCALED_HEALING.node(), (Object)false);
        config.set(SkillSetting.HEALING_SCALE_EXPRESSION.node(), (Object)"1");
        return config;
    }

    @Override
    public String getDescription(Hero hero) {
        double healing = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.HEALING.node(), 125, false);
        healing = this.getScaledHealing(hero, healing);
        double healingIncrease = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.HEALING_INCREASE_PER_WISDOM.node(), 2.0, false);
        return this.getDescription().replace("$1", Util.decFormat.format(healing += (double)hero.getAttributeValue(AttributeType.WISDOM) * healingIncrease)).replace("$2", Util.decFormat.format(healing * Heroes.properties.selfHeal));
    }

    @Override
    public SkillResult use(Hero hero, LivingEntity target, String[] args) {
        Player player = hero.getPlayer();
        CharacterTemplate targetCharacter = this.plugin.getCharacterManager().getCharacter(target);
        double healing = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.HEALING, 125, false);
        healing = this.getScaledHealing(hero, healing);
        double healingIncrease = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.HEALING_INCREASE_PER_WISDOM, 2.0, false);
        healing += (double)hero.getAttributeValue(AttributeType.WISDOM) * healingIncrease;
        double targetHealth = target.getHealth();
        if (targetHealth >= target.getMaxHealth()) {
            if (player.equals(target)) {
                Messaging.send((CommandSender)player, "You are already at full health.", new Object[0]);
            } else {
                Messaging.send((CommandSender)player, "Target is already fully healed.", new Object[0]);
            }
            return SkillResult.INVALID_TARGET_NO_MSG;
        }
        if (!targetCharacter.tryHeal(hero, this, healing)) {
            return SkillResult.CANCELLED;
        }
        this.removeEffects(hero, targetCharacter);
        this.broadcastExecuteText(hero, target);
        this.applySoundEffects(player.getWorld(), target);
        this.applyParticleEffects(player.getWorld(), target);
        return SkillResult.NORMAL;
    }

    protected void removeEffects(Hero healer, CharacterTemplate target) {
    }

    protected void applySoundEffects(World world, LivingEntity target) {
        world.playSound(target.getLocation(), Sound.ENTITY_PLAYER_BURP, 0.5f, 1.0f);
    }

    protected void applyParticleEffects(World world, LivingEntity target) {
        world.spawnParticle(Particle.VILLAGER_HAPPY, target.getLocation().add(0.0, 0.5, 0.0), 25, 1.0, 1.0, 1.0, 1.0, (Object)0);
    }
}

